/* CUSTOM VARS START */
/* REAL_TABLE_NAME: `wp_addonlibrary_addons`; */
/* PRE_TABLE_NAME: `1695331832_wp_addonlibrary_addons`; */
/* CUSTOM VARS END */

CREATE TABLE IF NOT EXISTS `1695331832_wp_addonlibrary_addons` ( `id` bigint(20) NOT NULL AUTO_INCREMENT, `title` varchar(255) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL, `name` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL, `alias` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL, `addontype` varchar(128) COLLATE utf8mb4_unicode_520_ci DEFAULT NULL, `description` text COLLATE utf8mb4_unicode_520_ci, `ordering` int(11) NOT NULL, `templates` mediumtext COLLATE utf8mb4_unicode_520_ci, `config` mediumtext COLLATE utf8mb4_unicode_520_ci, `catid` int(11) DEFAULT NULL, `is_active` tinyint(4) DEFAULT NULL, `test_slot1` text COLLATE utf8mb4_unicode_520_ci, `test_slot2` text COLLATE utf8mb4_unicode_520_ci, `test_slot3` text COLLATE utf8mb4_unicode_520_ci, PRIMARY KEY (`id`)) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_520_ci;
INSERT INTO `1695331832_wp_addonlibrary_addons` (`id`, `title`, `name`, `alias`, `addontype`, `description`, `ordering`, `templates`, `config`, `catid`, `is_active`, `test_slot1`, `test_slot2`, `test_slot3`) VALUES (1,'Animated Mouse Scroll Icon','animated_mouse_scroll_icon_elementor','animated_mouse_scroll_icon','elementor','The Animated Mouse Scroll Icon is a small micro animation to indicate to users they need to scroll down the page to view more. You can make the icon an anchor point that scrolls down to any section when clicked on.\n',1,'{\"html\":\"<div class=\\\"scroll-downs\\\" style=\\\"text-align:{{alignment}};\\\">\\n  {% if enable_link == \\\"true\\\" %}<a href=\\\"{{link}}\\\" {{link_html_attributes|raw}}>{% endif %}\\t\\n  <div class=\\\"mousey\\\">\\n    <div class=\\\"scroller\\\"><\\/div>\\n  <\\/div>\\n  {% if enable_link == \\\"true\\\" %}<\\/a>{% endif %}\\t\\n<\\/div>\",\"css\":\".mousey {\\n  border-style:solid;\\n  box-sizing: border-box;\\n  display:inline-block;\\n  text-align:center;\\n}\\n.scroller {\\n  border-radius: 50px;\\n  animation-name: scroll;\\n  animation-duration: 2.2s;\\n  animation-timing-function: cubic-bezier(.15,.41,.69,.94);\\n  animation-iteration-count: infinite;\\n  display:inline-block;\\n}\\n@keyframes scroll {\\n  0% { opacity: 0; }\\n  10% { transform: translateY(0); opacity: 1; }\\n  100% { transform: translateY(15px); opacity: 0;}\\n}\"}','{\"options\":{\"enable_items\":\"false\",\"items_section_title\":\"\",\"items_section_heading\":\"\",\"path_assets\":\"animated_mouse_scroll_icon\",\"js_as_module\":false,\"addon_icon\":\"fas fa-mouse-pointer\",\"dynamic_addon\":\"false\",\"dynamic_post_enable_customfields\":\"false\",\"dynamic_post_enable_category\":\"false\",\"description\":\"The Animated Mouse Scroll Icon is a small micro animation to indicate to users they need to scroll down the page to view more. You can make the icon an anchor point that scrolls down to any section when clicked on.\\n\",\"link_resource\":\"https:\\/\\/youtu.be\\/irBiclaedss\",\"link_preview\":\"https:\\/\\/unlimited-elements.com\\/animated-mouse-scroll-icon-widget-for-elementor\\/\",\"show_small_icon\":\"true\",\"preview_size_unite_selected_text\":\"Full Size\",\"preview_size\":\"full\",\"preview_custom_width\":\"\",\"preview_bgcol\":\"#ffffff\",\"special\":\"\",\"is_free_addon\":true,\"is_new_addon\":false,\"is_last_updated\":false,\"is_trending\":false},\"params\":[{\"type\":\"uc_dropdown\",\"title\":\"Alignment\",\"name\":\"alignment\",\"description\":\"\",\"options\":{\"Center\":\"center\",\"Left\":\"left\",\"Right\":\"right\"},\"default_value\":\"center\",\"__attr_catid__\":\"cat_style_e39pin3y\"},{\"type\":\"uc_colorpicker\",\"title\":\"Color\",\"name\":\"color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".mousey\",\"selector_value\":\"border-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_e39pin3y\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Link\",\"name\":\"enable_link\",\"description\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_link\",\"title\":\"Link\",\"name\":\"link\",\"description\":\"\",\"default_value\":\"#\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_slider\",\"title\":\"Height\",\"name\":\"height\",\"description\":\"\",\"default_value\":\"40\",\"min\":\"25\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".mousey\",\"selector_value\":\"height: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_e39pin3y\"},{\"type\":\"uc_slider\",\"title\":\"Width\",\"name\":\"width\",\"description\":\"\",\"default_value\":\"25\",\"min\":\"10\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".mousey\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_e39pin3y\"},{\"type\":\"uc_slider\",\"title\":\"Scroller Width\",\"name\":\"scroller_width\",\"description\":\"\",\"default_value\":\"3\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".scroller\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_xe1289fx\"},{\"type\":\"uc_slider\",\"title\":\"Scroller Height\",\"name\":\"scroller_height\",\"description\":\"\",\"default_value\":\"10\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".scroller\",\"selector_value\":\"height: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_xe1289fx\"},{\"type\":\"uc_slider\",\"title\":\"Scroller Space from Top\",\"name\":\"scroller_space_from_top\",\"description\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".scroller\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_xe1289fx\"},{\"type\":\"uc_colorpicker\",\"title\":\"Scroller Color\",\"name\":\"scroller_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".scroller\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_xe1289fx\"},{\"type\":\"uc_slider\",\"title\":\"Border Width\",\"name\":\"border_width\",\"description\":\"\",\"default_value\":\"2\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".mousey\",\"selector_value\":\"border-width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_e39pin3y\"},{\"type\":\"uc_slider\",\"title\":\"Border Radius\",\"name\":\"border_radius\",\"description\":\"\",\"default_value\":\"50\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".mousey\",\"selector_value\":\"border-radius: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_e39pin3y\"}],\"params_items\":[{\"type\":\"uc_textfield\",\"title\":\"Title\",\"name\":\"title\",\"description\":\"\",\"default_value\":\"\",\"limited_edit\":\"true\"}],\"includes\":{\"js\":[],\"jslib\":[],\"css\":[]},\"variables_item\":[],\"variables_main\":[],\"params_cats\":[{\"id\":\"cat_general_general\",\"title\":\"General\",\"tab\":\"content\"},{\"id\":\"cat_style_e39pin3y\",\"title\":\"Style\",\"tab\":\"style\"},{\"id\":\"cat_style_xe1289fx\",\"title\":\"Scroller\",\"tab\":\"style\"}]}',1,1,NULL,NULL,NULL),(2,'Counter','statistic_counter_elementor','statistic_counter','elementor','Showcasing your business statistics and show fun facts and figures on your Elementor website.',1,'{\"html\":\"<div class=\\\"uc_box_counter {{hover_animation}}\\\" id=\\\"{{uc_id}}\\\">\\n  <div class=\\\"uc_counter_box\\\" style=\\\"\\\">\\n          \\n{% if show_icon == \\\"true\\\" %}\\n           \\n          {% if type == \\\"icon\\\" %}\\n          <div class=\\\"counter_icon\\\">{{icon_html|raw}}<\\/div>\\n          <div class=\\\"ue_icon_spacer\\\"><\\/div>\\n          {% endif %}\\t\\n    \\n          {% if type == \\\"image\\\" %}\\n          <div class=\\\"counter_image\\\"><img src=\\\"{{image}}\\\" {{image_attributes|raw}}><\\/div>\\n          <div class=\\\"ue_icon_spacer\\\"><\\/div>\\n          {% endif %}\\n{% endif %}\\t\\n\\n          \\n    \\n\\t\\t  <div>\\n          <div class=\\\"counter_number\\\">{{before}} <span class=\\\"counter\\\">{{number}}<\\/span> {{after}}<\\/div>\\n            {% if show_divider == \\\"true\\\" %}<div class=\\\"ue_divider_holder\\\"><div class=\\\"ue_divider\\\"><\\/div><\\/div>{% endif %}\\n          {% if show_title == \\\"true\\\" %}\\n\\t\\t  <div class=\\\"counter_label\\\"> {{title|raw}}<\\/div>\\n          {% endif %}\\n        <\\/div>\\n  <\\/div>    \\n<\\/div>\",\"css\":\"#{{uc_id}} * { \\n  box-sizing: border-box; \\n}\\n#{{uc_id}} .uc_counter_box { \\n  display:inline-flex;\\n  width:100%;\\n  align-items:center;\\n  justify-content:center;\\n  margin:0 auto;\\n}\\n\\n#{{uc_id}} .counter_icon\\n{\\n  display:inline-flex;\\n  justify-content:center;\\n  align-items:center;\\n  line-height:1em;\\n  flex-grow:0;\\n  flex-shrink:0;\\n  position:relative;\\n  transition:0.3s;\\n}\\n\\n#{{uc_id}} .counter_icon i\\n{\\n  transition:0.3s;\\n}\\n\\n#{{uc_id}} .counter_icon svg\\n{\\n  width:1em;\\n  height:1em;\\n  transition:0.3s;\\n}\\n\\n#{{uc_id}} .ue_icon_spacer\\n{\\n  flex-grow:0;\\n  flex-shrink:0;\\n}\\n\\n#{{uc_id}} .ue_divider\\n{\\n  display:inline-flex;\\n}\\n\\n#{{uc_id}} .ue_divider_holder\\n{\\n  font-size:0px;\\n}\\n\\n\\n#{{uc_id}} .counter_image\\n{\\n  flex-grow:0;\\n  flex-shrink:0;\\n  display:inline-flex;\\n}\\n\\n#{{uc_id}} .counter_image img\\n{\\n  width:100%;\\n}\\n\\n#{{uc_id}} .ue_image_spacer\\n{\\n  flex-grow:0;\\n  flex-shrink:0;\\n}\\n\\n#{{uc_id}} .counter\\n{\\n\\tvisibility: hidden;\\n}\",\"js\":\"jQuery(document).ready(function(){\\t\\nfunction {{uc_id}}_start(){\\n      \\t\\n      \\t( () => {\\n         const counterUp = window.counterUp[\\\"default\\\"];\\n          const el = document.querySelector(\'#{{uc_id}}\');\\n          const counter = document.querySelector(\'#{{uc_id}} .counter\');\\n          new Waypoint( {\\n            element: el,\\n            handler: (direction) => { \\n              if ( direction == \'down\' ) {\\n                counterUp(counter, {\\n                  duration: {{counter_duration}},\\n                  delay: {{skip_count}},\\n                }); \\n              }\\n            },\\n            offset: \'{{viewport_offset}}%\',\\n          } );\\n      }) ();\\n    \\t\\n}if(jQuery(\\\"#{{uc_id}}\\\").length) {{uc_id}}_start(); else\\n\\tjQuery( document ).on( \'elementor\\/popup\\/show\', () => { if(jQuery(\\\"#{{uc_id}}\\\").length) {{uc_id}}_start();});\\n});\"}','{\"options\":{\"enable_items\":\"false\",\"items_section_title\":\"\",\"items_section_heading\":\"\",\"path_assets\":\"uc_box_counter\",\"js_as_module\":false,\"addon_icon\":\"far fa-arrow-alt-circle-up\",\"dynamic_addon\":\"false\",\"dynamic_post_enable_customfields\":\"false\",\"dynamic_post_enable_category\":\"false\",\"description\":\"Showcasing your business statistics and show fun facts and figures on your Elementor website.\",\"link_resource\":\"https:\\/\\/youtu.be\\/h9Kq_sjFqGk\",\"link_preview\":\"https:\\/\\/unlimited-elements.com\\/statistic-counters-for-elementor\",\"show_small_icon\":\"true\",\"preview_size_unite_selected_text\":\"Column Size\",\"preview_size\":\"column\",\"preview_custom_width\":\"\",\"preview_bgcol\":\"#ffffff\",\"is_free_addon\":true,\"is_new_addon\":false,\"is_last_updated\":false,\"is_trending\":false},\"params\":[{\"type\":\"uc_textfield\",\"title\":\"Title\",\"name\":\"title\",\"description\":\"\",\"default_value\":\"Year\",\"font_editable\":false,\"__attr_catid__\":\"cat_general_general\",\"value\":\"Year\"},{\"type\":\"uc_textfield\",\"title\":\"Number\",\"name\":\"number\",\"description\":\"\",\"default_value\":\"100\",\"font_editable\":\"false\",\"value\":\"10\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_typography\",\"title\":\"Number Typography\",\"name\":\"number_typography\",\"description\":\"\",\"selector1\":\".counter_number\",\"selector2\":\"\",\"selector3\":\"\",\"value\":\"\",\"__attr_catid__\":\"cat_style_8itoar2l\"},{\"type\":\"uc_colorpicker\",\"title\":\"Number Color\",\"name\":\"number_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".counter_number\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_8itoar2l\",\"value\":\"#000000\"},{\"type\":\"uc_textfield\",\"title\":\"Before Number\",\"name\":\"before\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"\",\"font_editable\":\"false\",\"value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_textfield\",\"title\":\"After Number\",\"name\":\"after\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"\",\"font_editable\":\"false\",\"value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Alignment\",\"name\":\"alignment\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"options\":{\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"center\",\"selector\":\".uc_counter_box\",\"selector_value\":\"text-align:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_jhlxxx2i\"},{\"type\":\"uc_background\",\"title\":\"Box Background\",\"name\":\"background_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"background_type\":\"none\",\"solid_color\":\"\",\"solid_bg_image\":\"\",\"solid_bg_image_position\":\"\",\"solid_bg_image_repeat\":\"\",\"solid_bg_image_size\":\"\",\"gradient_color1\":\"\",\"gradient_color2\":\"\",\"selector\":\".uc_counter_box\",\"__attr_catid__\":\"cat_style_jhlxxx2i\"},{\"type\":\"uc_padding\",\"title\":\"Box Padding\",\"name\":\"box_padding\",\"description\":\"\",\"is_responsive\":\"false\",\"desktop_top\":\"30\",\"desktop_right\":\"30\",\"desktop_bottom\":\"30\",\"desktop_left\":\"30\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".uc_counter_box\",\"value\":\"\",\"__attr_catid__\":\"cat_style_jhlxxx2i\"},{\"type\":\"uc_slider\",\"title\":\"Box Border Radius\",\"name\":\"box_border_radius\",\"description\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"selector\":\".uc_counter_box\",\"selector_value\":\"border-radius: {{SIZE}}{{UNIT}};\",\"value\":\"0\",\"__attr_catid__\":\"cat_style_jhlxxx2i\"},{\"type\":\"uc_slider\",\"title\":\"Icon Width\",\"name\":\"icon_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"42\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".counter_icon\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_8c087umu\"},{\"type\":\"uc_slider\",\"title\":\"Icon Height\",\"name\":\"icon_height\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"42\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".counter_icon\",\"selector_value\":\"height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_8c087umu\"},{\"type\":\"uc_colorpicker\",\"title\":\"Icon Color\",\"name\":\"icon_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"#ffffff\",\"selector\":\".counter_icon\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":true,\"selector2\":\".counter_icon svg\",\"selector2_value\":\"fill:{{VALUE}};\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_8c087umu\"},{\"type\":\"uc_colorpicker\",\"title\":\"Icon Background Color\",\"name\":\"icon_background_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".counter_icon\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_8c087umu\",\"value\":\"#000000\"},{\"type\":\"uc_border\",\"title\":\"Icon Border\",\"name\":\"icon_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".counter_icon\",\"__attr_catid__\":\"cat_style_8c087umu\"},{\"type\":\"uc_slider\",\"title\":\"Icon Size (inner)\",\"name\":\"icon_size\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"24\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".counter_icon\",\"selector_value\":\"font-size: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_8c087umu\"},{\"type\":\"uc_dropdown\",\"title\":\"Icon Type\",\"name\":\"icon_type\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"options\":{\"Radius\":\"radius\",\"Shape\":\"shape\"},\"default_value\":\"radius\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_8c087umu\"},{\"type\":\"uc_dropdown\",\"title\":\"Icon Shape\",\"name\":\"icon_background_shape\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"icon_type\",\"condition_operator\":\"equal\",\"condition_value\":\"shape\",\"label_block\":false,\"options\":{\"None\":\"none\",\"Triangle\":\"polygon(50% 0%, 0% 100%, 100% 100%)\",\"Trapezoid\":\"polygon(20% 0%, 80% 0%, 100% 100%, 0% 100%)\",\"Parallelogram\":\"polygon(25% 0%, 100% 0%, 75% 100%, 0% 100%)\",\"Rhombus\":\"polygon(50% 0%, 100% 50%, 50% 100%, 0% 50%)\",\"Pentagon\":\"polygon(50% 0%, 100% 38%, 82% 100%, 18% 100%, 0% 38%)\",\"Hexagon\":\"polygon(50% 0%, 100% 25%, 100% 75%, 50% 100%, 0% 75%, 0% 25%)\",\"Heptagon\":\"polygon(50% 0%, 90% 20%, 100% 60%, 75% 100%, 25% 100%, 0% 60%, 10% 20%)\",\"Octagon\":\"polygon(30% 0%, 70% 0%, 100% 30%, 100% 70%, 70% 100%, 30% 100%, 0% 70%, 0% 30%)\",\"Nonagon\":\"polygon(50% 0%, 83% 12%, 100% 43%, 94% 78%, 68% 100%, 32% 100%, 6% 78%, 0% 43%, 17% 12%)\",\"Decagon\":\"polygon(50% 0%, 80% 10%, 100% 35%, 100% 70%, 80% 90%, 50% 100%, 20% 90%, 0% 70%, 0% 35%, 20% 10%)\",\"Bevel\":\"polygon(20% 0%, 80% 0%, 100% 20%, 100% 80%, 80% 100%, 20% 100%, 0% 80%, 0% 20%);clip-path: polygon(20% 0%, 80% 0%, 100% 20%, 100% 80%, 80% 100%, 20% 100%, 0% 80%, 0% 20%)\",\"Rabbet\":\"polygon(0% 15%, 15% 15%, 15% 0%, 85% 0%, 85% 15%, 100% 15%, 100% 85%, 85% 85%, 85% 100%, 15% 100%, 15% 85%, 0% 85%)\",\"Left Arrow\":\"polygon(40% 0%, 40% 20%, 100% 20%, 100% 80%, 40% 80%, 40% 100%, 0% 50%)\",\"Right Arrow\":\"polygon(0% 20%, 60% 20%, 60% 0%, 100% 50%, 60% 100%, 60% 80%, 0% 80%)\",\"Left Point\":\"polygon(25% 0%, 100% 1%, 100% 100%, 25% 100%, 0% 50%)\",\"Right Point\":\"polygon(0% 0%, 75% 0%, 100% 50%, 75% 100%, 0% 100%)\",\"Left Chevron\":\"polygon(100% 0%, 75% 50%, 100% 100%, 25% 100%, 0% 50%, 25% 0%)\",\"Right Chevron\":\"polygon(75% 0%, 100% 50%, 75% 100%, 0% 100%, 25% 50%, 0% 0%)\"},\"default_value\":\"none\",\"selector\":\".counter_icon\",\"selector_value\":\"clip-path:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_8c087umu\"},{\"type\":\"uc_border\",\"title\":\"Box Border\",\"name\":\"box_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".uc_counter_box\",\"__attr_catid__\":\"cat_style_jhlxxx2i\"},{\"type\":\"uc_colorpicker\",\"title\":\"Title Color\",\"name\":\"title_color\",\"description\":\"\",\"default_value\":\"#979797\",\"selector\":\".counter_label\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_lwij3e57\",\"value\":\"#979797\"},{\"type\":\"uc_typography\",\"title\":\"Title Typography\",\"name\":\"title_typography\",\"description\":\"\",\"selector1\":\".counter_label\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_lwij3e57\",\"value\":\"\"},{\"type\":\"uc_slider\",\"title\":\"Title Spacing\",\"name\":\"title_spacing\",\"description\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".counter_label\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_lwij3e57\",\"value\":\"10\"},{\"type\":\"uc_slider\",\"title\":\"Number Spacing\",\"name\":\"number_spacing\",\"description\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".counter_number\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_8itoar2l\",\"value\":\"10\"},{\"type\":\"uc_dropdown\",\"title\":\"Layout\",\"name\":\"layout\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"options\":{\"Column\":\"column\",\"Column Reverse\":\"column-reverse\",\"Row\":\"row\",\"Row Reverse\":\"row-reverse\"},\"default_value\":\"column\",\"selector\":\".uc_counter_box\",\"selector_value\":\"flex-direction:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Icon Radius\",\"name\":\"icon_radius\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"icon_type\",\"condition_operator\":\"equal\",\"condition_value\":\"radius\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".counter_icon\",\"__attr_catid__\":\"cat_style_8c087umu\"},{\"type\":\"uc_margins\",\"title\":\"Icon Margin\",\"name\":\"icon_margin\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".counter_icon\",\"__attr_catid__\":\"cat_style_8c087umu\"},{\"type\":\"uc_slider\",\"title\":\"Icon Spacing\",\"name\":\"icon_spacing\",\"description\":\"Space between icon and content\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_icon_spacer\",\"selector_value\":\"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_8c087umu\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Icon\",\"name\":\"show_icon\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_u5s57flh\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Title\",\"name\":\"show_title\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_u5s57flh\"},{\"type\":\"uc_slider\",\"title\":\"Box Max Width\",\"name\":\"box_max_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"\",\"min\":\"0\",\"max\":\"1000\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_counter_box\",\"selector_value\":\"max-width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_jhlxxx2i\"},{\"type\":\"uc_hover_animations\",\"title\":\"Hover Animation\",\"name\":\"hover_animation\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Divider\",\"name\":\"show_divider\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_u5s57flh\"},{\"type\":\"uc_slider\",\"title\":\"Divider Width\",\"name\":\"divider_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"30\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_divider\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_9e9xem11\"},{\"type\":\"uc_slider\",\"title\":\"Divider Height\",\"name\":\"divider_height\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"2\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_divider\",\"selector_value\":\"height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_9e9xem11\"},{\"type\":\"uc_margins\",\"title\":\"Divider Marigin\",\"name\":\"divider_marigin\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"is_responsive\":true,\"desktop_top\":\"10\",\"desktop_right\":\"0\",\"desktop_bottom\":\"10\",\"desktop_left\":\"0\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue_divider_holder\",\"__attr_catid__\":\"cat_style_9e9xem11\"},{\"type\":\"uc_border\",\"title\":\"Box Border Hover\",\"name\":\"box_border_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".uc_counter_box:hover\",\"__attr_catid__\":\"cat_style_zr2axw88\"},{\"type\":\"uc_background\",\"title\":\"Box Background Hover\",\"name\":\"box_background_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"background_type\":\"none\",\"solid_color\":\"\",\"solid_bg_image\":\"\",\"solid_bg_image_position\":\"\",\"solid_bg_image_repeat\":\"\",\"solid_bg_image_size\":\"\",\"gradient_color1\":\"\",\"gradient_color2\":\"\",\"selector\":\".uc_counter_box:hover\",\"__attr_catid__\":\"cat_style_zr2axw88\"},{\"type\":\"uc_colorpicker\",\"title\":\"Icon Color Hover\",\"name\":\"icon_color_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"\",\"selector\":\".uc_counter_box:hover .counter_icon\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":true,\"selector2\":\".uc_counter_box:hover .counter_icon svg\",\"selector2_value\":\"fill:{{VALUE}};\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_zr2axw88\"},{\"type\":\"uc_colorpicker\",\"title\":\"Icon Background Hover\",\"name\":\"icon_background_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"\",\"selector\":\".uc_counter_box:hover .counter_icon\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_zr2axw88\"},{\"type\":\"uc_dropdown\",\"title\":\"Type\",\"name\":\"type\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"options\":{\"Icon\":\"icon\",\"Image\":\"image\"},\"default_value\":\"icon\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_icon_library\",\"title\":\"Icon\",\"name\":\"icon\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"type\",\"condition_operator\":\"equal\",\"condition_value\":\"icon\",\"default_value\":\"fas fa-heart\",\"enable_svg\":true,\"put_svg_as\":\"svg\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_image\",\"title\":\"Image\",\"name\":\"image\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"type\",\"condition_operator\":\"equal\",\"condition_value\":\"image\",\"default_value\":\"[url_assets]\\/icon.gif\",\"add_image_sizes\":false,\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_slider\",\"title\":\"Image Width\",\"name\":\"image_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"64\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px_percent\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".counter_image\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_iulzgskl\"},{\"type\":\"uc_slider\",\"title\":\"Image Height\",\"name\":\"image_height\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".counter_image img\",\"selector_value\":\"height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_iulzgskl\"},{\"type\":\"uc_dropdown\",\"title\":\"Image Fit\",\"name\":\"image_fit\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"options\":{\"Cover\":\"cover\",\"Contain\":\"contain\"},\"default_value\":\"cover\",\"selector\":\".counter_image img\",\"selector_value\":\"object-fit: cover;\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_iulzgskl\"},{\"type\":\"uc_slider\",\"title\":\"Image Spacing\",\"name\":\"image_spacing\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue_image_spacer\",\"selector_value\":\"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_iulzgskl\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Image Radius\",\"name\":\"image_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".counter_image img\",\"__attr_catid__\":\"cat_style_iulzgskl\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Image Border\",\"name\":\"image_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".counter_image img\",\"__attr_catid__\":\"cat_style_iulzgskl\"},{\"type\":\"uc_background\",\"title\":\"Divider Background\",\"name\":\"divider_background\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"background_type\":\"solid\",\"solid_color\":\"#cccccc\",\"solid_bg_image\":\"\",\"solid_bg_image_position\":\"\",\"solid_bg_image_repeat\":\"\",\"solid_bg_image_size\":\"\",\"gradient_color1\":\"\",\"gradient_color2\":\"\",\"selector\":\".ue_divider\",\"__attr_catid__\":\"cat_style_9e9xem11\"},{\"type\":\"uc_number\",\"title\":\"Duration\",\"name\":\"counter_duration\",\"description\":\"Animation duration\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"1000\",\"unit\":\"ms\",\"unit_custom\":\"\",\"min_value\":\"100\",\"max_value\":\"10000\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_content_3i7g7u67\"},{\"type\":\"uc_number\",\"title\":\"Skip Count\",\"name\":\"skip_count\",\"description\":\"Counts the Number by the Skip Count value.\\n\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"10\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_content_3i7g7u67\"},{\"type\":\"uc_number\",\"title\":\"Viewport Offset\",\"name\":\"viewport_offset\",\"description\":\"This controls when the Number becomes visible and the count begins. \\n<br><br>\\n<b>The value is expressed in percentage relative to the viewport with 0 being the top of the screen and 100 the bottom of the screen.<\\/b>\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"95\",\"unit\":\"%\",\"unit_custom\":\"\",\"min_value\":\"0\",\"max_value\":\"100\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_content_3i7g7u67\"},{\"type\":\"uc_slider\",\"title\":\"Icon Vertical Position\",\"name\":\"icon_vertical_position\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"0\",\"min\":\"-200\",\"max\":\"200\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".counter_icon\",\"selector_value\":\"top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_8c087umu\"}],\"params_items\":[{\"type\":\"uc_textfield\",\"title\":\"Title\",\"name\":\"title\",\"description\":\"\",\"default_value\":\"\",\"limited_edit\":\"true\"}],\"includes\":{\"js\":[{\"url\":\"uc_box_counter\\/jquery.waypoints.min.js\",\"condition\":null,\"params\":{\"include_handle\":\"elementor-waypoints\",\"include_after_elementor_frontend\":true}},{\"url\":\"uc_box_counter\\/counterup2.min.js\",\"condition\":null,\"params\":null}],\"jslib\":[\"jquery\",\"font-awsome\"],\"css\":[]},\"variables_item\":[],\"variables_main\":[],\"params_cats\":[{\"id\":\"cat_general_general\",\"title\":\"General\",\"tab\":\"content\"},{\"id\":\"cat_content_u5s57flh\",\"title\":\"Layout\",\"tab\":\"content\"},{\"id\":\"cat_content_3i7g7u67\",\"title\":\"Animation\",\"tab\":\"content\"},{\"id\":\"cat_style_jhlxxx2i\",\"title\":\"Box\",\"tab\":\"style\"},{\"id\":\"cat_style_8c087umu\",\"title\":\"Icon\",\"tab\":\"style\"},{\"id\":\"cat_style_zr2axw88\",\"title\":\"Hover\",\"tab\":\"style\"},{\"id\":\"cat_style_iulzgskl\",\"title\":\"Image\",\"tab\":\"style\"},{\"id\":\"cat_style_8itoar2l\",\"title\":\"Number\",\"tab\":\"style\"},{\"id\":\"cat_style_9e9xem11\",\"title\":\"Divider\",\"tab\":\"style\"},{\"id\":\"cat_style_lwij3e57\",\"title\":\"Title\",\"tab\":\"style\"}]}',2,1,NULL,'{\"config\":{\"admin_label\":\"Box Counter\",\"title\":\"Year\",\"number\":\"10\",\"before\":\"\",\"after\":\"\",\"border_color\":\"#ececec\",\"text_color\":\"#b2b5be\",\"icon\":\"fa fa-clock-o\",\"duration_color\":\"#000000\",\"background_color\":\"#ffffff\"},\"items\":\"\"}',NULL),(3,'Slider Gallery','uc_slider_image_elementor','uc_slider_image','elementor','Beautifully Designed, Powerful, and easy to Customize Slider Gallery for Elementor.',1,'{\"html\":\"<div id=\\\"{{uc_id}}-wrapper\\\">\\n<div id=\\\"{{uc_id}}\\\" class=\\\"uc-items-wrapper {{remote_parent.class}} {{uc_filtering_addclass}}\\\" style=\\\"display:none; margin:0 auto;\\\" {{remote_parent.attributes|raw}} data-remote-type=\\\"gallery\\\" data-custom-sethtml=\\\"true\\\" {{uc_filtering_attributes|raw}}>\\n\\n{{put_items()}}\\n  \\n<\\/div>\\n<\\/div>\",\"html_item\":\"{{ucfunc(\\\"put_unite_gallery_item\\\",item.images)}}\",\"css\":\"#{{uc_id}}\\n{\\n  overflow:hidden;\\n}\\n\\n#{{uc_id}}-wrapper\\n{\\n  min-height:1px;\\n}\",\"js\":\"jQuery(document).ready(function(){\\t\\nfunction {{uc_id}}_start(){\\n  \\nvar objGallery = jQuery(\\\"#{{uc_id}}\\\");  \\n  \\n  var api = objGallery.unitegallery({\\n    gallery_theme: \\\"slider\\\",\\n    gallery_width:\'{{gallery_width_nounit}}%\',\\t\\t\\t\\t\\t\\t\\t\\/\\/gallery width\\t\\t\\n\\t\\t\\t\\t\\tgallery_height:{{gallery_height_nounit}},\\t\\t\\t\\t\\t\\t\\t\\/\\/gallery height\\n\\t\\t\\t\\t\\tgallery_min_width: 100,\\t\\t\\t\\t\\t\\t\\/\\/gallery minimal width when resizing\\n\\t\\t\\t\\t\\tgallery_min_height: 300,\\t\\t\\t\\t\\t\\/\\/gallery minimal height when resizing\\n\\t\\t\\t\\t\\tgallery_skin:\\\"default\\\",\\t\\t\\t\\t\\t\\t\\/\\/default, alexis etc... - the global skin of the gallery. Will change all gallery items by default.\\n\\t\\t\\t\\t\\tgallery_images_preload_type:\\\"minimal\\\",\\t\\t\\/\\/all , minimal , visible - preload type of the images.\\n\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\t\\n\\t\\t\\t\\t\\tgallery_autoplay:{{gallery_autoplay}},\\t\\t\\t\\t\\t\\t\\/\\/true \\/ false - begin slideshow autoplay on start\\n\\t\\t\\t\\t\\tgallery_play_interval: {{gallery_play_interval}},\\t\\t\\t\\t\\/\\/play interval of the slideshow\\n\\t\\t\\t\\t\\tgallery_pause_on_mouseover: {{gallery_pause_on_mouseover}},\\t\\t\\t\\/\\/true,false - pause on mouseover when playing slideshow true\\/false\\n\\t\\n\\t\\t\\t\\t\\tgallery_control_thumbs_mousewheel:{{gallery_control_thumbs_mousewheel}},\\t\\/\\/true,false - enable \\/ disable the mousewheel\\n\\t\\t\\t\\t\\tgallery_control_keyboard: {{gallery_control_keyboard}},\\t\\t\\t\\t\\/\\/true,false - enable \\/ disble keyboard controls\\n\\t\\t\\t\\t\\tgallery_carousel:{{gallery_carousel}},\\t\\t\\t\\t\\t\\t\\/\\/true,false - next button on last image goes to first image.\\n\\t\\n\\t\\t\\t\\t\\tgallery_preserve_ratio: {{gallery_preserve_ratio}},\\t\\t\\t\\t\\/\\/true, false - preserver ratio when on window resize\\n\\t\\t\\t\\t\\tgallery_height_mobile:{{gallery_height_mobile_nounit}},\\t\\n                    gallery_debug_errors:true,\\t\\t\\t\\t\\t\\/\\/show error message when there is some error on the gallery area.\\n\\t\\t\\t\\t\\tslider_background_color:\\\"{{slider_background_color}}\\\",\\n\\n\\t\\t\\t\\t\\t\\/\\/slider options: \\n\\t\\n\\t\\t\\t\\t\\tslider_scale_mode: \\\"{{slider_scale_mode}}\\\",\\t\\/\\/fit: scale down and up the image to always fit the slider\\t\\t\\t\\t\\t\\t\\t\\t\\n\\t\\t\\t\\t\\tslider_scale_mode_media: \\\"fill\\\",\\t\\t\\t\\/\\/fit, down, full scale mode on media items\\n\\t\\t\\t\\t\\tslider_scale_mode_fullscreen: \\\"down\\\",\\t\\t\\/\\/fit, down, full scale mode on fullscreen.\\n\\t\\t\\t\\t\\tslider_item_padding_top: 0,\\t\\t\\t\\t\\t\\/\\/padding top of the slider item\\n\\t\\t\\t\\t\\tslider_item_padding_bottom: 0,\\t\\t\\t\\t\\/\\/padding bottom of the slider item\\n\\t\\t\\t\\t\\tslider_item_padding_left: 0,\\t\\t\\t\\t\\/\\/padding left of the slider item\\n\\t\\t\\t\\t\\tslider_item_padding_right: 0,\\t\\t\\t\\t\\/\\/padding right of the slider item\\n\\t\\n\\t\\t\\t\\t\\tslider_transition: \\\"{{slider_transition}}\\\",\\t\\t\\t\\t\\t\\/\\/fade, slide - the transition of the slide change\\n\\t\\t\\t\\t\\tslider_transition_speed:{{slider_transition_speed}},\\t\\t\\t\\t\\/\\/transition duration of slide change\\n\\t\\t\\t\\t\\tslider_transition_easing: \\\"easeInOutQuad\\\",\\t\\/\\/transition easing function of slide change\\n\\t\\n\\t\\t\\t\\t\\tslider_control_swipe:{{slider_control_swipe}},\\t\\t\\t\\t\\t\\/\\/true,false - enable swiping control\\n\\t\\t\\t\\t\\tslider_control_zoom:{{slider_control_zoom}},\\t\\t\\t\\t\\t\\/\\/true, false - enable zooming control\\n\\t\\t\\t\\t\\tslider_zoom_max_ratio: {{slider_zoom_max_ratio}},\\t\\t\\t\\t\\t\\/\\/max zoom ratio\\n\\t\\t\\t\\t\\tslider_loader_type: {{slider_loader_type}},\\t\\t\\t\\t\\t\\t\\/\\/shape of the loader (1-7)\\n\\t\\t\\t\\t\\tslider_loader_color:\\\"white\\\",\\n                    \\n                    slider_enable_bullets: {{slider_enable_bullets}},\\t\\t\\t\\t\\/\\/enable the bullets onslider element\\n\\t\\t\\t\\t\\tslider_bullets_skin: \\\"\\\",\\t\\t\\t\\t\\t\\/\\/skin of the bullets, if empty inherit from gallery skin\\n\\t\\t\\t\\t\\tslider_bullets_space_between: {{slider_bullets_space_between}},\\t\\t\\t\\/\\/set the space between bullets. If -1 then will be set default space from the skins\\n\\t\\t\\t\\t\\tslider_bullets_align_hor:\\\"{{slider_bullets_align_hor}}\\\",\\t\\t\\t\\/\\/left, center, right - bullets horizontal align\\n\\t\\t\\t\\t\\tslider_bullets_align_vert:\\\"{{slider_bullets_align_vert}}\\\",\\t\\t\\t\\/\\/top, middle, bottom - bullets vertical algin\\n\\t\\t\\t\\t\\tslider_bullets_offset_hor:{{slider_bullets_offset_hor}},\\t\\t\\t\\t\\/\\/bullets horizontal offset \\n\\t\\t\\t\\t\\tslider_bullets_offset_vert:{{slider_bullets_offset_vert}},\\t\\t\\t\\t\\/\\/bullets vertical offset\\n\\t\\n\\t\\t\\t\\t\\tslider_enable_arrows: {{slider_enable_arrows}},\\t\\t\\t\\t\\t\\/\\/enable arrows onslider element\\n\\t\\t\\t\\t\\tslider_arrows_skin: \\\"\\\",\\t\\t\\t\\t\\t\\t\\/\\/skin of the slider arrows, if empty inherit from gallery skin\\n\\t\\t\\t\\t\\tslider_arrow_left_align_hor:\\\"left\\\",\\t  \\t\\t\\/\\/left, center, right - left arrow horizonal align\\n\\t\\t\\t\\t\\tslider_arrow_left_align_vert:\\\"{{slider_arrow_align_vert}}\\\", \\t\\t\\/\\/top, middle, bottom - left arrow vertical align\\n\\t\\t\\t\\t\\tslider_arrow_left_offset_hor:{{arrow_horizontal_offset}},\\t\\t  \\t\\/\\/left arrow horizontal offset\\n\\t\\t\\t\\t\\tslider_arrow_left_offset_vert:{{arrow_offset_vertical}},\\t\\t  \\t\\/\\/left arrow vertical offset\\n\\t\\t\\t\\t\\tslider_arrow_right_align_hor:\\\"right\\\",   \\t\\/\\/left, center, right - right arrow horizontal algin\\n\\t\\t\\t\\t\\tslider_arrow_right_align_vert:\\\"{{slider_arrow_align_vert}}\\\", \\t\\/\\/top, middle, bottom - right arrow vertical align\\n\\t\\t\\t\\t\\tslider_arrow_right_offset_hor:{{arrow_horizontal_offset}},\\t   \\t\\t\\/\\/right arrow horizontal offset \\n\\t\\t\\t\\t\\tslider_arrow_right_offset_vert:{{arrow_offset_vertical}},\\t   \\t\\t\\/\\/right arrow vertical offset\\n\\t             \\n\\t\\t\\t\\t\\tslider_enable_progress_indicator: {{slider_enable_progress_indicator}},\\t\\t \\/\\/enable progress indicator element\\n\\t\\t\\t\\t\\tslider_progress_indicator_type: \\\"{{slider_progress_indicator_type}}\\\",\\t\\t \\/\\/pie, pie2, bar (if pie not supported, it will switch to bar automatically)\\n\\t\\t\\t\\t\\tslider_progress_indicator_align_hor:\\\"{{slider_progress_indicator_align_hor}}\\\",  \\/\\/left, center, right - progress indicator horizontal align\\n\\t\\t\\t\\t\\tslider_progress_indicator_align_vert:\\\"{{slider_progress_indicator_align_vert}}\\\",  \\/\\/top, middle, bottom - progress indicator vertical align\\n\\t\\t\\t\\t\\tslider_progress_indicator_offset_hor:{{slider_progress_indicator_offset_hor}},\\t \\/\\/progress indicator horizontal offset \\n\\t\\t\\t\\t\\tslider_progress_indicator_offset_vert:{{slider_progress_indicator_offset_vert}},\\t \\/\\/progress indicator vertical offset\\n\\t\\t\\t\\t\\tslider_progressbar_color:\\\"{{slider_progressbar_color}}\\\",\\t\\t\\t \\/\\/progress bar color\\n\\t\\t\\t\\t\\tslider_progressbar_opacity: {{slider_progressbar_opacity_nounit}},\\t\\t\\t \\/\\/progress bar opacity\\n\\t\\t\\t\\t\\tslider_progressbar_line_width: {{slider_progressbar_line_width_nounit}},\\t\\t\\t \\/\\/progress bar line width\\n\\t\\t\\t\\t\\tslider_progresspie_type_fill: false,\\t\\t \\/\\/false is stroke, true is fill - the progress pie type, stroke of fill\\n\\t\\t\\t\\t\\tslider_progresspie_color1: \\\"{{slider_progresspie_color1}}\\\", \\t\\t \\/\\/the first color of the progress pie\\n\\t\\t\\t\\t\\tslider_progresspie_color2: \\\"{{slider_progresspie_color2}}\\\",\\t\\t \\/\\/progress pie second color \\n\\t\\t\\t\\t\\tslider_progresspie_stroke_width: {{progress_pie_stroke_width_nounit}},\\t\\t\\t \\/\\/progress pie stroke width \\n\\t\\t\\t\\t\\tslider_progresspie_width: {{progress_pie_size_nounit}},\\t\\t\\t\\t \\/\\/progess pie width\\n\\t\\t\\t\\t\\tslider_progresspie_height:{{progress_pie_size_nounit}},\\t\\t\\t\\t \\/\\/progress pie height\\n\\t\\n\\t\\t\\t\\t    slider_enable_play_button: {{slider_enable_play_button}},\\t\\t\\t \\/\\/true,false - enable play \\/ pause button onslider element\\n\\t\\t\\t\\t    slider_play_button_skin: \\\"\\\",\\t\\t\\t\\t \\/\\/skin of the slider play button, if empty inherit from gallery skin\\n\\t\\t\\t\\t    slider_play_button_align_hor:\\\"{{slider_play_button_align_hor}}\\\",    \\t \\/\\/left, center, right - play button horizontal align\\n\\t\\t\\t\\t    slider_play_button_align_vert:\\\"{{slider_play_button_align_vert}}\\\",         \\/\\/top, middle, bottom - play button vertical align\\n\\t\\t\\t\\t    slider_play_button_offset_hor:{{slider_play_button_offset_hor}},\\t       \\t \\/\\/play button horizontal offset \\n\\t\\t\\t\\t    slider_play_button_offset_vert:{{slider_play_button_offset_vert}},\\t   \\t\\t \\/\\/play button vertical offset\\n\\t\\n\\t\\t\\t\\t    slider_enable_fullscreen_button: {{slider_enable_fullscreen_button}},\\t\\t \\/\\/true,false - enable fullscreen button onslider element\\n\\t\\t\\t\\t    slider_fullscreen_button_skin: \\\"\\\",\\t\\t\\t \\/\\/skin of the slider fullscreen button, if empty inherit from gallery skin\\n\\t\\t\\t\\t    slider_fullscreen_button_align_hor:\\\"{{slider_fullscreen_button_align_hor}}\\\",   \\/\\/left, center, right\\t- fullscreen button horizonatal align\\n\\t\\t\\t\\t    slider_fullscreen_button_align_vert:\\\"{{slider_fullscreen_button_align_vert}}\\\",   \\/\\/top, middle, bottom - fullscreen button vertical align\\n\\t\\t\\t\\t    slider_fullscreen_button_offset_hor:{{slider_fullscreen_button_offset_hor}},\\t     \\/\\/fullscreen button horizontal offset \\n\\t\\t\\t\\t    slider_fullscreen_button_offset_vert:{{slider_fullscreen_button_offset_vert}},\\t   \\t \\/\\/fullscreen button vertical offset\\n\\t\\n\\t\\t\\t\\t\\tslider_enable_zoom_panel: {{slider_enable_zoom_panel}},\\t\\t\\t\\t \\/\\/true,false - enable the zoom buttons, works together with zoom control.\\n\\t\\t\\t\\t\\tslider_zoompanel_skin: \\\"\\\",\\t\\t\\t\\t\\t \\/\\/skin of the slider zoom panel, if empty inherit from gallery skin\\t\\t  \\n\\t\\t\\t\\t\\tslider_zoompanel_align_hor:\\\"{{slider_zoompanel_align_hor}}\\\",    \\t\\t \\/\\/left, center, right - zoom panel horizontal align\\n\\t\\t\\t\\t\\tslider_zoompanel_align_vert:\\\"{{slider_zoompanel_align_vert}}\\\",     \\t \\t \\/\\/top, middle, bottom - zoom panel vertical align\\n\\t\\t\\t\\t\\tslider_zoompanel_offset_hor:{{slider_zoompanel_offset_hor}},\\t       \\t\\t \\/\\/zoom panel horizontal offset \\n\\t\\t\\t\\t\\tslider_zoompanel_offset_vert:{{slider_zoompanel_offset_vert}},\\t   \\t     \\/\\/zoom panel vertical offset\\n\\t\\n\\t\\t\\t\\t\\tslider_controls_always_on: true,\\t\\t     \\/\\/true,false - controls are always on, false - show only on mouseover\\n\\t\\t\\t\\t\\tslider_controls_appear_ontap: true,\\t\\t\\t \\/\\/true,false - appear controls on tap event on touch devices\\n\\t\\t\\t\\t\\tslider_controls_appear_duration: 300,\\t\\t \\/\\/the duration of appearing controls\\n\\t\\t\\t\\t\\tslider_videoplay_button_type: \\\"square\\\",\\t\\t  \\/\\/square, round - the videoplay button type, square or round\\t\\n                    \\n                    slider_enable_text_panel: {{slider_enable_text_panel}},\\t\\t\\t \\/\\/true,false - enable the text panel\\n\\t\\t\\t\\t\\tslider_textpanel_always_on: {{text_panel_always_on}},\\t\\t\\t \\/\\/true,false - text panel are always on, false - show only on mouseover\\n\\t\\t\\t\\t\\tslider_textpanel_text_valign:\\\"middle\\\",\\t\\t\\t\\/\\/middle, top, bottom - text vertical align\\n\\t\\t\\t\\t\\tslider_textpanel_padding_top:{{slider_textpanel_padding}},\\t\\t\\t\\t\\/\\/textpanel padding top \\n\\t\\t\\t\\t\\tslider_textpanel_padding_bottom:{{slider_textpanel_padding}},\\t\\t\\t\\t\\/\\/textpanel padding bottom\\n                    slider_textpanel_padding_right: {{slider_textpanel_padding}},\\t\\t\\t\\t\\/\\/cut some space for text from right\\n\\t\\t\\t\\t\\tslider_textpanel_padding_left: {{slider_textpanel_padding}},\\t\\t\\t\\t\\/\\/cut some space for text from left\\n\\t\\t\\t\\t\\tslider_textpanel_height: null,\\t\\t\\t\\t\\t\\/\\/textpanel height. if null it will be set dynamically\\n\\t\\t\\t\\t\\tslider_textpanel_padding_title_description: 5,\\t\\/\\/the space between the title and the description\\n\\t\\t\\t\\t\\tslider_textpanel_fade_duration: 200,\\t\\t\\t\\/\\/the fade duration of textpanel appear\\n\\t\\t\\t\\t\\tslider_textpanel_enable_title: {{slider_textpanel_enable_title}},\\t\\t\\t\\/\\/enable the title text\\n\\t\\t\\t\\t\\tslider_textpanel_enable_description: true,\\t\\t\\/\\/enable the description text\\n\\t\\t\\t\\t\\tslider_textpanel_enable_bg: true,\\t\\t\\t\\t\\/\\/enable the textpanel background\\n\\t\\t\\t\\t\\tslider_textpanel_bg_color:\\\"{{slider_textpanel_bg_color}}\\\",\\t\\t\\t\\/\\/textpanel background color\\n\\t\\t\\t\\t\\tslider_textpanel_bg_opacity: {{slider_textpanel_bg_opacity_nounit}},\\t\\t\\t\\t\\/\\/textpanel background opacity\\n                 \\n  });\\n  \\n  {{ucfunc(\\\"put_remote_parent_js\\\",\\\"objGallery\\\",\\\"unitegallery\\\")}}  \\n\\n   objGallery.on(\\\"uc_ajax_sethtml\\\",function(event, htmlItems, isAppend){      \\t\\n        api.changeItems(htmlItems);         \\n   });\\n  \\n  \\n}if(jQuery(\\\"#{{uc_id}}\\\").length) {{uc_id}}_start(); else\\n\\tjQuery( document ).on( \'elementor\\/popup\\/show\', () => { if(jQuery(\\\"#{{uc_id}}\\\").length) {{uc_id}}_start();});\\n});\"}','{\"options\":{\"enable_items\":\"false\",\"items_section_title\":\"\",\"items_section_heading\":\"\",\"items_title_field\":\"\",\"path_assets\":\"uc_slider_image\",\"js_as_module\":false,\"addon_icon\":\"fas fa-image\",\"dynamic_addon\":\"false\",\"dynamic_post_enable_customfields\":\"false\",\"dynamic_post_enable_category\":\"false\",\"description\":\"Beautifully Designed, Powerful, and easy to Customize Slider Gallery for Elementor.\",\"link_resource\":\"\",\"link_preview\":\"https:\\/\\/unlimited-elements.com\\/slider-gallery-widget-for-elementor\\/\",\"show_small_icon\":\"true\",\"preview_size_unite_selected_text\":\"Full Size\",\"preview_size\":\"full\",\"preview_custom_width\":\"\",\"preview_bgcol\":\"#ffffff\",\"special\":\"\",\"special_data\":\"\",\"is_free_addon\":true,\"is_new_addon\":false,\"is_last_updated\":false,\"is_trending\":false},\"params\":[{\"type\":\"uc_listing\",\"title\":\"Images\",\"name\":\"images\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"use_for\":\"gallery\",\"gallery_enable_video\":true,\"enable_pagination\":true,\"enable_ajax\":true,\"remote_type\":\"parent\",\"__attr_catid__\":\"cat_content_6ejbbeib\"},{\"type\":\"uc_listing\",\"title\":\"Remote Parent\",\"name\":\"remote_parent\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"use_for\":\"remote\",\"gallery_enable_video\":false,\"enable_pagination\":false,\"remote_type\":\"parent\",\"remote_widget_name\":\"Icon Carousel\",\"__attr_catid__\":\"cat_content_a9t44h5k\"},{\"type\":\"uc_slider\",\"title\":\"Max Width (%)\",\"name\":\"gallery_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"100\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"%\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_p9rpn3ze\"},{\"type\":\"uc_slider\",\"title\":\"Gallery Height\",\"name\":\"gallery_height\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"500\",\"min\":\"0\",\"max\":\"1000\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_p9rpn3ze\"},{\"type\":\"uc_radioboolean\",\"title\":\"Gallery Autoplay\",\"name\":\"gallery_autoplay\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_number\",\"title\":\"Autoplay Interval\",\"name\":\"gallery_play_interval\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"gallery_autoplay\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"3000\",\"unit\":\"ms\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Pause on Mouseover\",\"name\":\"gallery_pause_on_mouseover\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"gallery_autoplay\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Control Thumbs Mousewheel\",\"name\":\"gallery_control_thumbs_mousewheel\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Gallery Control Keyboard\",\"name\":\"gallery_control_keyboard\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Loop\",\"name\":\"gallery_carousel\",\"description\":\"Next button on last image goes to first image\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Preserve Ratio\",\"name\":\"gallery_preserve_ratio\",\"description\":\"Preserve ratio when on window resize\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_p9rpn3ze\"},{\"type\":\"uc_dropdown\",\"title\":\"Image Fit\",\"name\":\"slider_scale_mode\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Cover\":\"fill\",\"Contain\":\"fit\"},\"default_value\":\"fill\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Transition\",\"name\":\"slider_transition\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Slide\":\"slide\",\"Fade\":\"fade\"},\"default_value\":\"slide\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_slider\",\"title\":\"Gallery Height - Mobile\",\"name\":\"gallery_height_mobile\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"gallery_preserve_ratio\",\"condition_operator\":\"equal\",\"condition_value\":[\"\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"400\",\"min\":\"0\",\"max\":\"1000\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_p9rpn3ze\"},{\"type\":\"uc_number\",\"title\":\"Transition Speed\",\"name\":\"slider_transition_speed\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"300\",\"unit\":\"ms\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Swipe\",\"name\":\"slider_control_swipe\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Zoom\",\"name\":\"slider_control_zoom\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_number\",\"title\":\"Maximum Zoom Ratio\",\"name\":\"slider_zoom_max_ratio\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"3\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Loader Type\",\"name\":\"slider_loader_type\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"1\":\"1\",\"2\":\"2\",\"3\":\"3\",\"4\":\"4\",\"5\":\"5\",\"6\":\"6\",\"7\":\"7\"},\"default_value\":\"1\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Text Panel\",\"name\":\"slider_enable_text_panel\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_vqcy9egl\"},{\"type\":\"uc_radioboolean\",\"title\":\"Text Panel Always On\",\"name\":\"text_panel_always_on\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"slider_enable_text_panel\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_vqcy9egl\"},{\"type\":\"uc_number\",\"title\":\"Text Panel Padding\",\"name\":\"slider_textpanel_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"20\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_dk3l6nsv\"},{\"type\":\"uc_colorpicker\",\"title\":\"Text Panel BG Color\",\"name\":\"slider_textpanel_bg_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_dk3l6nsv\"},{\"type\":\"uc_slider\",\"title\":\"Textpanel Opacity\",\"name\":\"slider_textpanel_bg_opacity\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0.5\",\"min\":\"0\",\"max\":\"1\",\"step\":\"0.1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_dk3l6nsv\"},{\"type\":\"uc_radioboolean\",\"title\":\"Text Panel Title\",\"name\":\"slider_textpanel_enable_title\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"slider_enable_text_panel\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_vqcy9egl\"},{\"type\":\"uc_radioboolean\",\"title\":\"Text Panel Description\",\"name\":\"slider_textpanel_enable_description\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"slider_enable_text_panel\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_vqcy9egl\"},{\"type\":\"uc_number\",\"title\":\"Space Between Bullets\",\"name\":\"slider_bullets_space_between\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"5\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_9w28vily\"},{\"type\":\"uc_dropdown\",\"title\":\"Bullets Align\",\"name\":\"slider_bullets_align_hor\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"center\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_9w28vily\"},{\"type\":\"uc_dropdown\",\"title\":\"Bullets Vertical Align\",\"name\":\"slider_bullets_align_vert\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Top\":\"top\",\"Middle\":\"middle\",\"Bottom\":\"bottom\"},\"default_value\":\"bottom\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_9w28vily\"},{\"type\":\"uc_number\",\"title\":\"Bullets Offset\",\"name\":\"slider_bullets_offset_hor\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_9w28vily\"},{\"type\":\"uc_number\",\"title\":\"Bullets Offset Vertical\",\"name\":\"slider_bullets_offset_vert\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"20\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_9w28vily\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Play Button\",\"name\":\"slider_enable_play_button\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_vqcy9egl\"},{\"type\":\"uc_dropdown\",\"title\":\"Play Button Align\",\"name\":\"slider_play_button_align_hor\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"left\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_g7hn943b\"},{\"type\":\"uc_dropdown\",\"title\":\"Play Button Align Vertical\",\"name\":\"slider_play_button_align_vert\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Top\":\"top\",\"Middle\":\"middle\",\"Bottom\":\"bottom\"},\"default_value\":\"top\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_g7hn943b\"},{\"type\":\"uc_number\",\"title\":\"Play Button Offset Horizontal\",\"name\":\"slider_play_button_offset_hor\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"40\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_g7hn943b\"},{\"type\":\"uc_number\",\"title\":\"Play Button Offset Vertical\",\"name\":\"slider_play_button_offset_vert\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"8\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_g7hn943b\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Fullscreen Button\",\"name\":\"slider_enable_fullscreen_button\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_vqcy9egl\"},{\"type\":\"uc_dropdown\",\"title\":\"Fullscreen Button Align\",\"name\":\"slider_fullscreen_button_align_hor\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"left\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_1tffxg5b\"},{\"type\":\"uc_dropdown\",\"title\":\"Fullscreen Button Align Vertical\",\"name\":\"slider_fullscreen_button_align_vert\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"\",\"options\":{\"Top\":\"top\",\"Middle\":\"middle\",\"Bottom\":\"bottom\"},\"default_value\":\"top\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_1tffxg5b\"},{\"type\":\"uc_number\",\"title\":\"Fullscreen Button Horizontal Offset\",\"name\":\"slider_fullscreen_button_offset_hor\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"\",\"default_value\":\"11\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_1tffxg5b\"},{\"type\":\"uc_number\",\"title\":\"Fullscreen Button Vertical Offset\",\"name\":\"slider_fullscreen_button_offset_vert\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"\",\"default_value\":\"9\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_1tffxg5b\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Zoom Panel\",\"name\":\"slider_enable_zoom_panel\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_vqcy9egl\"},{\"type\":\"uc_dropdown\",\"title\":\"Zoom Panel Align\",\"name\":\"slider_zoompanel_align_hor\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"right\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_plvcbsb1\"},{\"type\":\"uc_dropdown\",\"title\":\"Zoom Panel Align Vertical\",\"name\":\"slider_zoompanel_align_vert\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Top\":\"top\",\"Center\":\"center\",\"Bottom\":\"bottom\"},\"default_value\":\"top\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_plvcbsb1\"},{\"type\":\"uc_number\",\"title\":\"Zoom Panel Horizontal Offset\",\"name\":\"slider_zoompanel_offset_hor\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"12\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_plvcbsb1\"},{\"type\":\"uc_number\",\"title\":\"Zoom Panel Vertical Offset\",\"name\":\"slider_zoompanel_offset_vert\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"10\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_plvcbsb1\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Progress Indicator\",\"name\":\"slider_enable_progress_indicator\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_vqcy9egl\"},{\"type\":\"uc_dropdown\",\"title\":\"Indicator Type\",\"name\":\"slider_progress_indicator_type\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Pie\":\"pie\",\"Bar\":\"bar\"},\"default_value\":\"pie\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_7kxqlcyi\"},{\"type\":\"uc_dropdown\",\"title\":\"Indicator Align\",\"name\":\"slider_progress_indicator_align_hor\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"left\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_7kxqlcyi\"},{\"type\":\"uc_dropdown\",\"title\":\"Indicator Align Vertical\",\"name\":\"slider_progress_indicator_align_vert\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Top\":\"top\",\"Middle\":\"middle\",\"Bottom\":\"bottom\"},\"default_value\":\"top\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_7kxqlcyi\"},{\"type\":\"uc_number\",\"title\":\"Indicator Horizontal Offset\",\"name\":\"slider_progress_indicator_offset_hor\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"11\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_7kxqlcyi\"},{\"type\":\"uc_number\",\"title\":\"Indicator Vertical Offset\",\"name\":\"slider_progress_indicator_offset_vert\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"40\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_7kxqlcyi\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Bullets\",\"name\":\"slider_enable_bullets\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_vqcy9egl\"},{\"type\":\"uc_radioboolean\",\"title\":\"Enable Arrows\",\"name\":\"slider_enable_arrows\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_vqcy9egl\"},{\"type\":\"uc_dropdown\",\"title\":\"Arrow Align Vertical\",\"name\":\"slider_arrow_align_vert\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Top\":\"top\",\"Middle\":\"middle\",\"Bottom\":\"bottom\"},\"default_value\":\"middle\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_g073f84z\"},{\"type\":\"uc_number\",\"title\":\"Arrow Horizontal Offset\",\"name\":\"arrow_horizontal_offset\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"15\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_g073f84z\"},{\"type\":\"uc_colorpicker\",\"title\":\"Background Color\",\"name\":\"slider_background_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_p9rpn3ze\"},{\"type\":\"uc_number\",\"title\":\"Arrow Offset Vertical\",\"name\":\"arrow_offset_vertical\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_g073f84z\"},{\"type\":\"uc_slider\",\"title\":\"Progress Bar Opacity\",\"name\":\"slider_progressbar_opacity\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0.6\",\"min\":\"0\",\"max\":\"1\",\"step\":\"0.1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_7kxqlcyi\"},{\"type\":\"uc_colorpicker\",\"title\":\"Progress Bar Color\",\"name\":\"slider_progressbar_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#ffffff\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_7kxqlcyi\"},{\"type\":\"uc_slider\",\"title\":\"Progress Bar Line Height\",\"name\":\"slider_progressbar_line_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"3\",\"min\":\"1\",\"max\":\"20\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_7kxqlcyi\"},{\"type\":\"uc_colorpicker\",\"title\":\"Progress Pie Color\",\"name\":\"slider_progresspie_color1\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#B5B5B5\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_7kxqlcyi\"},{\"type\":\"uc_slider\",\"title\":\"Progress Pie Size\",\"name\":\"progress_pie_size\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"30\",\"min\":\"10\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_7kxqlcyi\"},{\"type\":\"uc_slider\",\"title\":\"Progress Pie Stroke Width\",\"name\":\"progress_pie_stroke_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"3\",\"min\":\"1\",\"max\":\"10\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_7kxqlcyi\"},{\"type\":\"uc_border\",\"title\":\"Border\",\"name\":\"border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".uc-items-wrapper\",\"__attr_catid__\":\"cat_style_p9rpn3ze\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Radius\",\"name\":\"radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".uc-items-wrapper\",\"__attr_catid__\":\"cat_style_p9rpn3ze\"},{\"type\":\"uc_boxshadow\",\"title\":\"Box Shadow\",\"name\":\"box_shadow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector\":\".uc-items-wrapper\",\"__attr_catid__\":\"cat_style_p9rpn3ze\"},{\"type\":\"uc_colorpicker\",\"title\":\"Arrows Color\",\"name\":\"arrows_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#ffffff\",\"selector\":\".ug-arrow-left svg polyline,.ug-arrow-right svg polyline\",\"selector_value\":\"stroke:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_g073f84z\"},{\"type\":\"uc_typography\",\"title\":\"Text Panel Title Typography\",\"name\":\"text_panel_title_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector1\":\".ug-textpanel-title\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_dk3l6nsv\"},{\"type\":\"uc_typography\",\"title\":\"Text Panel Description Typography\",\"name\":\"text_panel_descruotuib_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"selector1\":\".ug-textpanel-description\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_dk3l6nsv\"}],\"params_items\":[{\"type\":\"uc_textfield\",\"title\":\"Title\",\"name\":\"title\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"Lemon Slice\",\"font_editable\":\"false\"},{\"type\":\"uc_editor\",\"title\":\"Description\",\"name\":\"si_description\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"Those are peppers\"},{\"type\":\"uc_textfield\",\"title\":\"Link\",\"name\":\"si_link\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"#\",\"font_editable\":\"false\"},{\"type\":\"uc_imagebase\",\"name\":\"imagebase_fields\",\"title\":\"Image Base Fields\"}],\"includes\":{\"js\":[{\"url\":\"uc_slider_image\\/ug-theme-slider.js\",\"condition\":null,\"params\":null}],\"jslib\":[\"jquery\",\"unitegallery\"],\"css\":[]},\"variables_item\":[],\"variables_main\":[],\"params_cats\":[{\"params\":[{\"type\":\"uc_listing\",\"title\":\"Images\",\"name\":\"images\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"use_for\":\"gallery\",\"gallery_enable_video\":true,\"enable_pagination\":false,\"remote_type\":\"parent\",\"__attr_catid__\":\"cat_content_6ejbbeib\"}],\"expire\":1645539336228,\"id\":\"cat_content_6ejbbeib\",\"title\":\"Gallery Source\",\"tab\":\"content\"},{\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_general_general\",\"title\":\"General\",\"tab\":\"content\"},{\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_content_vqcy9egl\",\"title\":\"Layout\",\"tab\":\"content\"},{\"params\":[{\"type\":\"uc_listing\",\"title\":\"Remote Parent\",\"name\":\"remote_parent\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"use_for\":\"remote\",\"gallery_enable_video\":false,\"enable_pagination\":false,\"remote_type\":\"parent\",\"remote_widget_name\":\"Icon Carousel\",\"__attr_catid__\":\"cat_content_a9t44h5k\"}],\"expire\":1645624874841,\"id\":\"cat_content_a9t44h5k\",\"title\":\"Connected Widgets Settings\",\"tab\":\"content\"},{\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_p9rpn3ze\",\"title\":\"General\",\"tab\":\"style\"},{\"enable_condition\":true,\"condition_attribute\":\"slider_enable_text_panel\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_dk3l6nsv\",\"title\":\"Text Panel\",\"tab\":\"style\"},{\"enable_condition\":true,\"condition_attribute\":\"slider_enable_play_button\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_g7hn943b\",\"title\":\"Play Button\",\"tab\":\"style\"},{\"enable_condition\":true,\"condition_attribute\":\"slider_enable_fullscreen_button\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_1tffxg5b\",\"title\":\"Fullscreen Button\",\"tab\":\"style\"},{\"enable_condition\":true,\"condition_attribute\":\"slider_enable_zoom_panel\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_plvcbsb1\",\"title\":\"Zoom Panel\",\"tab\":\"style\"},{\"enable_condition\":true,\"condition_attribute\":\"slider_enable_progress_indicator\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_7kxqlcyi\",\"title\":\"Progress Indicator\",\"tab\":\"style\"},{\"enable_condition\":true,\"condition_attribute\":\"slider_enable_bullets\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_9w28vily\",\"title\":\"Bullets\",\"tab\":\"style\"},{\"enable_condition\":true,\"condition_attribute\":\"slider_enable_arrows\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_g073f84z\",\"title\":\"Arrows\",\"tab\":\"style\"}]}',3,1,NULL,'{\"config\":{\"si_transition_unite_selected_text\":\"Slide\",\"si_transition\":\"slide\",\"si_transition_speed\":\"3000\",\"si_gallery_autoplay_unite_selected_text\":\"True\",\"si_gallery_autoplay\":\"true\",\"si_enable_bullets_unite_selected_text\":\"True\",\"si_enable_bullets\":\"true\",\"si_enable_arrows_unite_selected_text\":\"True\",\"si_enable_arrows\":\"true\",\"si_gallery_width\":\"900\",\"si_gallery_height\":\"500\"},\"items\":[{\"title\":\"gallery1\",\"image\":\"[url_assets]\\/gallery1.jpg\"},{\"title\":\"gallery2\",\"image\":\"[url_assets]\\/gallery2.jpg\"},{\"title\":\"gallery3\",\"image\":\"[url_assets]\\/gallery3.jpg\"}]}',NULL),(4,'Tile Gallery','uc_tiles_grid_image_elementor','uc_tiles_grid_image','elementor','This widget is an effective tool for adding a tile grid image gallery slider to your website. The gallery lets you navigate using bullets or arrows and opens the images or videos in a light-box.',2,'{\"html\":\"<div id=\\\"{{uc_id}}\\\" style=\\\"display:none;\\\" class=\\\"uc-items-wrapper{{uc_filtering_addclass}}\\\" data-custom-sethtml=\\\"true\\\" {{uc_filtering_attributes|raw}}>\\n\\n{{put_items()}}\\n  \\n<\\/div>\",\"html_item\":\"{{ucfunc(\\\"put_unite_gallery_item\\\",item.images)}}\",\"js\":\"jQuery(document).ready(function(){\\t\\nfunction {{uc_id}}_start(){\\n\\n  var objWrapper = jQuery(\\\"#{{uc_id}}\\\");\\n  \\n  var api = objWrapper.unitegallery({\\n    gallery_theme:\\\"tilesgrid\\\",\\n    grid_num_rows:{{grid_num_rows}},\\n\\tgallery_width:\\\"{{gallery_width}}\\\",\\n    tile_width: {{tile_width_nounit}},\\n    tile_height: {{tile_height_nounit}},\\n    grid_space_between_rows: {{grid_space_between_rows_nounit}},\\n    grid_space_between_cols: {{grid_space_between_cols_nounit}},\\n    tiles_align:\\\"{{tiles_align}}\\\",\\n    tile_as_link: {{tile_as_link}},\\n    tile_link_newpage: {{tile_link_newpage}},\\n    tile_enable_icons: {{tile_enable_icons}},\\n    tile_overlay_opacity: {{tile_overlay_opacity_nounit}},\\n    tile_overlay_color: \\\"{{tile_overlay_color}}\\\", \\n    theme_navigation_type: \\\"{{theme_navigation_type}}\\\",\\n                                    \\n    theme_bullets_margin_top: {{theme_bullets_margin_top_nounit}},\\n    theme_bullets_color: \\\"{{theme_bullets_color}}\\\",\\n    bullets_space_between: {{bullets_space_between_nounit}},\\n    theme_arrows_margin_top: {{theme_arrows_margin_top_nounit}},\\t\\t\\t\\n\\ttheme_space_between_arrows: {{theme_space_between_arrows_nounit}},\\n    theme_navigation_align: \\\"{{theme_navigation_align}}\\\",\\n                                    \\n    tile_enable_textpanel:{{tile_enable_textpanel}},\\n    tile_textpanel_always_on: {{tile_textpanel_always_on}},\\n    tile_textpanel_appear_type: \\\"{{tile_textpanel_appear_type}}\\\",\\n    tile_textpanel_position:\\\"{{tile_textpanel_position}}\\\",\\n    tile_textpanel_padding_top:{{tile_textpanel_padding_nounit}},\\t\\t \\t\\n\\ttile_textpanel_padding_bottom:{{tile_textpanel_padding_nounit}},\\t \\t\\n\\ttile_textpanel_padding_right: {{tile_textpanel_padding_nounit}},\\t \\t\\n\\ttile_textpanel_padding_left: {{tile_textpanel_padding_nounit}},\\n    tile_textpanel_bg_color:\\\"{{tile_textpanel_bg_color}}\\\",\\n    tile_textpanel_bg_opacity:{{tile_textpanel_bg_opacity_nounit}},\\n    tile_textpanel_title_text_align:\\\"{{tile_textpanel_title_text_align}}\\\",\\n    tile_textpanel_title_color:\\\"{{tile_textpanel_title_color}}\\\",\\n                                    \\n                                    \\n    lightbox_type: \\\"{{lightbox_type}}\\\",\\n    lightbox_hide_arrows_onvideoplay: {{lightbox_hide_arrows_onvideoplay}},\\n    lightbox_arrows_position: \\\"{{lightbox_arrows_position}}\\\",                                \\n    lightbox_overlay_color:\\\"{{lightbox_overlay_color}}\\\",\\n    lightbox_overlay_opacity:{{lightbox_overlay_opacity_nounit}},\\t\\n    lightbox_show_numbers: {{lightbox_show_numbers}},\\n    lightbox_show_textpanel: {{lightbox_show_textpanel}},\\n    lightbox_slider_control_swipe:{{lightbox_slider_control_swipe}},\\n    lightbox_slider_control_zoom:{{lightbox_slider_control_zoom}},\\n    lightbox_textpanel_title_text_align:\\\"{{lightbox_textpanel_title_text_align}}\\\",                    \\n    lightbox_slider_image_border: {{lightbox_slider_image_border}},\\n    lightbox_slider_image_border_width: {{lightbox_slider_image_border_width_nounit}},\\n    lightbox_slider_image_border_color: \\\"{{lightbox_slider_image_border_color}}\\\",\\n    lightbox_slider_image_border_radius: {{lightbox_slider_image_border_radius_nounit}},\\n                                    \\n    {% if tile_enable_border == \\\"true\\\" %}\\n        tile_enable_border:{{tile_enable_border}},\\n        tile_border_color:\\\"{{tile_border_color}}\\\",\\n        tile_border_width:{{tile_border_width_nounit}},\\n        tile_border_radius:{{tile_border_radius_nounit}}, \\n        \\n    {% endif %}\\t\\n\\n    {% if tile_enable_shadow == \\\"true\\\" %}\\n        tile_enable_shadow:{{tile_enable_shadow}},\\n        tile_shadow_color:\\\"{{tile_shadow_color}}\\\",\\n        tile_shadow_h:{{tile_shadow_h_nounit}},\\t\\t\\t\\t\\t\\n\\t\\ttile_shadow_v:{{tile_shadow_v_nounit}},\\t\\t\\t\\t\\t\\n\\t\\ttile_shadow_blur:{{tile_shadow_blur_nounit}},\\t\\t\\t\\t\\t\\n\\t\\ttile_shadow_spread:{{tile_shadow_spread_nounit}},\\n     {% endif %}                               \\n    \\n    {% if tile_enable_image_effect == \\\"true\\\" %}\\n        tile_enable_image_effect:{{tile_enable_image_effect}},\\n        tile_image_effect_type: \\\"{{tile_image_effect_type}}\\\",\\n        tile_image_effect_reverse: {{tile_image_effect_reverse}},\\n    {% endif %}   \\n\\t\\n  });\\n\\n   objWrapper.on(\\\"uc_ajax_sethtml\\\",function(event, htmlItems, isAppend){      \\t\\n        api.changeItems(htmlItems);         \\n   });\\n \\n  \\n}if(jQuery(\\\"#{{uc_id}}\\\").length) {{uc_id}}_start(); else\\n\\tjQuery( document ).on( \'elementor\\/popup\\/show\', () => { if(jQuery(\\\"#{{uc_id}}\\\").length) {{uc_id}}_start();});\\n});\"}','{\"options\":{\"enable_items\":\"false\",\"items_section_title\":\"\",\"items_section_heading\":\"\",\"path_assets\":\"uc_tiles_grid_image\",\"js_as_module\":false,\"addon_icon\":\"fas fa-image\",\"dynamic_addon\":\"false\",\"dynamic_post_enable_customfields\":\"false\",\"dynamic_post_enable_category\":\"false\",\"description\":\"This widget is an effective tool for adding a tile grid image gallery slider to your website. The gallery lets you navigate using bullets or arrows and opens the images or videos in a light-box.\",\"link_resource\":\"\",\"link_preview\":\"https:\\/\\/unlimited-elements.com\\/tile-gallery-widget-for-elementor\\/\",\"show_small_icon\":\"true\",\"preview_size_unite_selected_text\":\"Full Size\",\"preview_size\":\"full\",\"preview_custom_width\":\"\",\"preview_bgcol\":\"#ffffff\",\"special\":\"\",\"is_free_addon\":true,\"is_new_addon\":false,\"is_last_updated\":false,\"is_trending\":false},\"params\":[{\"type\":\"uc_slider\",\"title\":\"Gallery Max Width (%)\",\"name\":\"gallery_width\",\"description\":\"\",\"enable_condition\":\"false\",\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":\"\",\"label_block\":\"false\",\"tabname\":\"\",\"default_value\":\"100\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"%\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":\"false\",\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Theme Navigation Type\",\"name\":\"theme_navigation_type\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Bullets\":\"bullets\",\"Arrows\":\"arrows\"},\"default_value\":\"bullets\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Thumb Quality\",\"name\":\"thumb_quality\",\"description\":\"\",\"options\":{\"Thumbnail\":\"thumb\",\"Original Image\":\"original\"},\"default_value\":\"original\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_listing\",\"title\":\"Images\",\"name\":\"images\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"use_for\":\"gallery\",\"gallery_enable_video\":true,\"enable_pagination\":true,\"enable_ajax\":true,\"remote_type\":\"parent\",\"__attr_catid__\":\"cat_content_l8ma70cx\"},{\"type\":\"uc_radioboolean\",\"title\":\"Tile Enable Text Panel\",\"name\":\"tile_enable_textpanel\",\"description\":\"\",\"enable_condition\":\"false\",\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":\"\",\"label_block\":\"false\",\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Tile Text Panel Always On\",\"name\":\"tile_textpanel_always_on\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_textpanel\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Text Panel Position\",\"name\":\"tile_textpanel_position\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_textpanel\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Inside Bottom\":\"inside_bottom\",\"Inside Top\":\"inside_top\",\"Inside Center\":\"inside_center\",\"Top\":\"top\",\"Bottom\":\"bottom\"},\"default_value\":\"inside_bottom\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Tile Text Panel Appear Type\",\"name\":\"tile_textpanel_appear_type\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_textpanel\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Slide\":\"slide\",\"Fade\":\"fade\"},\"default_value\":\"slide\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Tile As Link\",\"name\":\"tile_as_link\",\"description\":\"No lightbox will appear\",\"enable_condition\":\"false\",\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":\"\",\"label_block\":\"false\",\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Tile Link New Page\",\"name\":\"tile_link_newpage\",\"description\":\"\",\"enable_condition\":\"false\",\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":\"\",\"label_block\":\"false\",\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Tile Enable Icons\",\"name\":\"tile_enable_icons\",\"description\":\"\",\"enable_condition\":\"false\",\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":\"\",\"label_block\":\"false\",\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Tile Enable Image Effect\",\"name\":\"tile_enable_image_effect\",\"description\":\"\",\"enable_condition\":\"false\",\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":\"\",\"label_block\":\"false\",\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Tile Image Effect Type\",\"name\":\"tile_image_effect_type\",\"description\":\"\",\"enable_condition\":\"true\",\"condition_attribute\":\"tile_enable_image_effect\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":\"\",\"label_block\":\"false\",\"tabname\":\"\",\"options\":{\"Black and White\":\"bw\",\"Blur\":\"blur\",\"Sepia\":\"sepia\"},\"default_value\":\"bw\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":\"false\",\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Tile Image Effect Reverse\",\"name\":\"tile_image_effect_reverse\",\"description\":\"\",\"enable_condition\":\"true\",\"condition_attribute\":\"tile_enable_image_effect\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":\"\",\"label_block\":\"false\",\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_colorpicker\",\"title\":\"Tile Panel Bg Color\",\"name\":\"tile_textpanel_bg_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_8pqf7dn7\"},{\"type\":\"uc_colorpicker\",\"title\":\"Tile Text Panel Title Color\",\"name\":\"tile_textpanel_title_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#ffffff\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_8pqf7dn7\"},{\"type\":\"uc_slider\",\"title\":\"Tile Text Panel BG Opacity\",\"name\":\"tile_textpanel_bg_opacity\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"1\",\"min\":\"0\",\"max\":\"1\",\"step\":\"0.1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_8pqf7dn7\"},{\"type\":\"uc_dropdown\",\"title\":\" Tile Text Panel Title Text Align\",\"name\":\"tile_textpanel_title_text_align\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Right\":\"right\",\"Center\":\"center\"},\"default_value\":\"center\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_8pqf7dn7\"},{\"type\":\"uc_slider\",\"title\":\"Tile Text Panel Padding\",\"name\":\"tile_textpanel_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_8pqf7dn7\"},{\"type\":\"uc_colorpicker\",\"title\":\"Lightbox Overlay Color\",\"name\":\"lightbox_overlay_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_ptm6hurv\"},{\"type\":\"uc_slider\",\"title\":\"Lightbox Overlay Opacity\",\"name\":\"lightbox_overlay_opacity\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0.8\",\"min\":\"0\",\"max\":\"1\",\"step\":\"0.1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_ptm6hurv\"},{\"type\":\"uc_radioboolean\",\"title\":\"Lightbox Image Border\",\"name\":\"lightbox_slider_image_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_ptm6hurv\"},{\"type\":\"uc_slider\",\"title\":\"Lightbox Image Border Width\",\"name\":\"lightbox_slider_image_border_width\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"lightbox_slider_image_border\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_ptm6hurv\"},{\"type\":\"uc_colorpicker\",\"title\":\"Lightbox Image Border Color\",\"name\":\"lightbox_slider_image_border_color\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"lightbox_slider_image_border\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#ffffff\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_ptm6hurv\"},{\"type\":\"uc_slider\",\"title\":\"Lightbox Image Border Radius\",\"name\":\"lightbox_slider_image_border_radius\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"lightbox_slider_image_border\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_ptm6hurv\"},{\"type\":\"uc_dropdown\",\"title\":\"Lightbox Type\",\"name\":\"lightbox_type\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Wide\":\"wide\",\"Compact\":\"compact\"},\"default_value\":\"wide\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_radioboolean\",\"title\":\"Lightbox Hide Arrows On Video Play\",\"name\":\"lightbox_hide_arrows_onvideoplay\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_dropdown\",\"title\":\"Lightbox Arrows Position\",\"name\":\"lightbox_arrows_position\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"lightbox_type\",\"condition_operator\":\"equal\",\"condition_value\":[\"compact\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Sides\":\"sides\",\"Inside\":\"inside\"},\"default_value\":\"sides\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_radioboolean\",\"title\":\"Lightbox Show Numbers\",\"name\":\"lightbox_show_numbers\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_radioboolean\",\"title\":\"Lightbox Show Text Panel\",\"name\":\"lightbox_show_textpanel\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_radioboolean\",\"title\":\"Lightbox Swipe\",\"name\":\"lightbox_slider_control_swipe\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_radioboolean\",\"title\":\"Lightbox Zoom\",\"name\":\"lightbox_slider_control_zoom\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_dropdown\",\"title\":\"Lightbox Text Panel Align\",\"name\":\"lightbox_textpanel_title_text_align\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"center\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_radioboolean\",\"title\":\"Tile Enable Border\",\"name\":\"tile_enable_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_m8b876bb\"},{\"type\":\"uc_colorpicker\",\"title\":\"Border Color\",\"name\":\"tile_border_color\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_border\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_m8b876bb\"},{\"type\":\"uc_slider\",\"title\":\"Tile Border Width\",\"name\":\"tile_border_width\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_border\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"3\",\"min\":\"0\",\"max\":\"20\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_m8b876bb\"},{\"type\":\"uc_slider\",\"title\":\"Tile Border Radius\",\"name\":\"tile_border_radius\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_border\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"20\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_m8b876bb\"},{\"type\":\"uc_radioboolean\",\"title\":\"Tile Enable Shadow\",\"name\":\"tile_enable_shadow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_rhwily40\"},{\"type\":\"uc_colorpicker\",\"title\":\"Tile Shadow Color\",\"name\":\"tile_shadow_color\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_shadow\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"rgba(0, 0, 0, 0.51)\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_rhwily40\"},{\"type\":\"uc_slider\",\"title\":\"Tile Shadow Horizontal Offset\",\"name\":\"tile_shadow_h\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_shadow\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"-100\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rhwily40\"},{\"type\":\"uc_slider\",\"title\":\"Tile Shadow Vertical Offset\",\"name\":\"tile_shadow_v\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_shadow\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"-100\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rhwily40\"},{\"type\":\"uc_slider\",\"title\":\"Tile Shadow Blur\",\"name\":\"tile_shadow_blur\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_shadow\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"5\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rhwily40\"},{\"type\":\"uc_slider\",\"title\":\"Tile Shadow Spread\",\"name\":\"tile_shadow_spread\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_shadow\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rhwily40\"},{\"type\":\"uc_number\",\"title\":\"Grid Num of Rows\",\"name\":\"grid_num_rows\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"3\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_slider\",\"title\":\"Tile Width\",\"name\":\"tile_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"250\",\"min\":\"0\",\"max\":\"1000\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_slider\",\"title\":\"Tile Height\",\"name\":\"tile_height\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"250\",\"min\":\"0\",\"max\":\"1000\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_slider\",\"title\":\"Columns Spacing\",\"name\":\"grid_space_between_cols\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_slider\",\"title\":\"Row Spacing\",\"name\":\"grid_space_between_rows\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_dropdown\",\"title\":\"Tiles Align\",\"name\":\"tiles_align\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"center\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_slider\",\"title\":\"Tile Overlay Opacity\",\"name\":\"tile_overlay_opacity\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0.5\",\"min\":\"0\",\"max\":\"1\",\"step\":\"0.1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_colorpicker\",\"title\":\"Tile Overlay Color\",\"name\":\"tile_overlay_color\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_slider\",\"title\":\"Bullets Margin Top\",\"name\":\"theme_bullets_margin_top\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fvicjn1e\"},{\"type\":\"uc_dropdown\",\"title\":\"Bullets Color\",\"name\":\"theme_bullets_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Gray\":\"gray\",\"Brown\":\"brown\",\"Blue\":\"blue\",\"Green\":\"green\",\"Red\":\"red\"},\"default_value\":\"gray\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_fvicjn1e\"},{\"type\":\"uc_slider\",\"title\":\"Bullets Spacing\",\"name\":\"bullets_space_between\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fvicjn1e\"},{\"type\":\"uc_slider\",\"title\":\"Arrows Margin Top\",\"name\":\"theme_arrows_margin_top\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fvicjn1e\"},{\"type\":\"uc_slider\",\"title\":\"Arrows Spacing\",\"name\":\"theme_space_between_arrows\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fvicjn1e\"},{\"type\":\"uc_dropdown\",\"title\":\"Navigation Alignment\",\"name\":\"theme_navigation_align\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"center\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_fvicjn1e\"}],\"params_items\":[{\"type\":\"uc_textfield\",\"title\":\"Title\",\"name\":\"title\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"\",\"font_editable\":\"true\"},{\"type\":\"uc_imagebase\",\"name\":\"imagebase_fields\",\"title\":\"Image Base Fields\"}],\"includes\":{\"js\":[{\"url\":\"uc_tiles_grid_image\\/ug-theme-tilesgrid.js\",\"condition\":null,\"params\":null}],\"jslib\":[\"jquery\",\"unitegallery\"],\"css\":[]},\"variables_item\":[],\"variables_main\":[],\"params_cats\":[{\"params\":[{\"type\":\"uc_listing\",\"title\":\"Images\",\"name\":\"images\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"use_for\":\"gallery\",\"gallery_enable_video\":true,\"enable_pagination\":false,\"remote_type\":\"parent\",\"__attr_catid__\":\"cat_content_l8ma70cx\"}],\"expire\":1645539490916,\"id\":\"cat_content_l8ma70cx\",\"title\":\"Gallery Source\",\"tab\":\"content\"},{\"id\":\"cat_general_general\",\"title\":\"General\",\"tab\":\"content\"},{\"params\":[{\"type\":\"uc_dropdown\",\"title\":\"Lightbox Type\",\"name\":\"lightbox_type\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Wide\":\"wide\",\"Compact\":\"compact\"},\"default_value\":\"wide\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_radioboolean\",\"title\":\"Lightbox Hide Arrows On Video Play\",\"name\":\"lightbox_hide_arrows_onvideoplay\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_dropdown\",\"title\":\"Lightbox Arrows Position\",\"name\":\"lightbox_arrows_position\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"lightbox_type\",\"condition_operator\":\"equal\",\"condition_value\":[\"compact\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Sides\":\"sides\",\"Inside\":\"inside\"},\"default_value\":\"sides\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_radioboolean\",\"title\":\"Lightbox Show Numbers\",\"name\":\"lightbox_show_numbers\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_radioboolean\",\"title\":\"Lightbox Show Text Panel\",\"name\":\"lightbox_show_textpanel\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_radioboolean\",\"title\":\"Lightbox Swipe\",\"name\":\"lightbox_slider_control_swipe\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_radioboolean\",\"title\":\"Lightbox Zoom\",\"name\":\"lightbox_slider_control_zoom\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"},{\"type\":\"uc_dropdown\",\"title\":\"Lightbox Text Panel Align\",\"name\":\"lightbox_textpanel_title_text_align\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"center\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_content_fdyd1us0\"}],\"expire\":1652689525935,\"id\":\"cat_content_fdyd1us0\",\"title\":\"Lightbox\",\"tab\":\"content\"},{\"params\":[{\"type\":\"uc_dropdown\",\"title\":\"Tiles Align\",\"name\":\"tiles_align\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Center\":\"center\",\"Right\":\"right\"},\"default_value\":\"center\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_slider\",\"title\":\"Tiles Column  Width\",\"name\":\"tiles_col_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"250\",\"min\":\"1\",\"max\":\"1000\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_slider\",\"title\":\"Tiles Space Between Cols\",\"name\":\"tiles_space_between_cols\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_slider\",\"title\":\"Tiles Space Between Cols Mobile\",\"name\":\"tiles_space_between_cols_mobile\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_slider\",\"title\":\"Tile Overlay Opacity\",\"name\":\"tile_overlay_opacity\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0.5\",\"min\":\"0\",\"max\":\"1\",\"step\":\"0.1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_06r99thq\"},{\"type\":\"uc_colorpicker\",\"title\":\"Tile Overlay Color\",\"name\":\"tile_overlay_color\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_06r99thq\"}],\"expire\":1652689802152,\"id\":\"cat_style_06r99thq\",\"title\":\"Tile\",\"tab\":\"style\"},{\"params\":[{\"type\":\"uc_radioboolean\",\"title\":\"Tile Enable Border\",\"name\":\"tile_enable_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_m8b876bb\"},{\"type\":\"uc_colorpicker\",\"title\":\"Border Color\",\"name\":\"tile_border_color\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_border\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_m8b876bb\"},{\"type\":\"uc_slider\",\"title\":\"Tile Border Width\",\"name\":\"tile_border_width\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_border\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"3\",\"min\":\"0\",\"max\":\"20\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_m8b876bb\"},{\"type\":\"uc_slider\",\"title\":\"Tile Border Radius\",\"name\":\"tile_border_radius\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_border\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"20\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_m8b876bb\"}],\"expire\":1652689591599,\"id\":\"cat_style_m8b876bb\",\"title\":\"Tile Border\",\"tab\":\"style\"},{\"params\":[{\"type\":\"uc_radioboolean\",\"title\":\"Tile Enable Shadow\",\"name\":\"tile_enable_shadow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_rhwily40\"},{\"type\":\"uc_colorpicker\",\"title\":\"Tile Shadow Color\",\"name\":\"tile_shadow_color\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_shadow\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"rgba(0, 0, 0, 0.51)\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_rhwily40\"},{\"type\":\"uc_slider\",\"title\":\"Tile Shadow Horizontal Offset\",\"name\":\"tile_shadow_h\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_shadow\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"-100\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rhwily40\"},{\"type\":\"uc_slider\",\"title\":\"Tile Shadow Vertical Offset\",\"name\":\"tile_shadow_v\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_shadow\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"-100\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rhwily40\"},{\"type\":\"uc_slider\",\"title\":\"Tile Shadow Blur\",\"name\":\"tile_shadow_blur\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_shadow\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"5\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rhwily40\"},{\"type\":\"uc_slider\",\"title\":\"Tile Shadow Spread\",\"name\":\"tile_shadow_spread\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"tile_enable_shadow\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rhwily40\"}],\"expire\":1652689702198,\"id\":\"cat_style_rhwily40\",\"title\":\"Tile Shadow\",\"tab\":\"style\"},{\"params\":[{\"type\":\"uc_colorpicker\",\"title\":\"Tile Panel Bg Color\",\"name\":\"tile_textpanel_bg_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_8pqf7dn7\"},{\"type\":\"uc_colorpicker\",\"title\":\"Tile Text Panel Title Color\",\"name\":\"tile_textpanel_title_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#ffffff\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_8pqf7dn7\"},{\"type\":\"uc_slider\",\"title\":\"Tile Text Panel BG Opacity\",\"name\":\"tile_textpanel_bg_opacity\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"1\",\"min\":\"0\",\"max\":\"1\",\"step\":\"0.1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_8pqf7dn7\"},{\"type\":\"uc_dropdown\",\"title\":\" Tile Text Panel Title Text Align\",\"name\":\"tile_textpanel_title_text_align\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":true,\"tabname\":\"\",\"options\":{\"Left\":\"left\",\"Right\":\"right\",\"Center\":\"center\"},\"default_value\":\"center\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_style_8pqf7dn7\"},{\"type\":\"uc_slider\",\"title\":\"Tile Text Panel Padding\",\"name\":\"tile_textpanel_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_8pqf7dn7\"}],\"expire\":1652689320175,\"id\":\"cat_style_8pqf7dn7\",\"title\":\"Tile Text Panel\",\"tab\":\"style\"},{\"params\":[{\"type\":\"uc_colorpicker\",\"title\":\"Lightbox Overlay Color\",\"name\":\"lightbox_overlay_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_ptm6hurv\"},{\"type\":\"uc_slider\",\"title\":\"Lightbox Overlay Opacity\",\"name\":\"lightbox_overlay_opacity\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0.8\",\"min\":\"0\",\"max\":\"1\",\"step\":\"0.1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_ptm6hurv\"},{\"type\":\"uc_radioboolean\",\"title\":\"Lightbox Image Border\",\"name\":\"lightbox_slider_image_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_ptm6hurv\"},{\"type\":\"uc_slider\",\"title\":\"Lightbox Image Border Width\",\"name\":\"lightbox_slider_image_border_width\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"lightbox_slider_image_border\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_ptm6hurv\"},{\"type\":\"uc_colorpicker\",\"title\":\"Lightbox Image Border Color\",\"name\":\"lightbox_slider_image_border_color\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"lightbox_slider_image_border\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#ffffff\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_ptm6hurv\"},{\"type\":\"uc_slider\",\"title\":\"Lightbox Image Border Radius\",\"name\":\"lightbox_slider_image_border_radius\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"lightbox_slider_image_border\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_ptm6hurv\"}],\"expire\":1652689475774,\"id\":\"cat_style_ptm6hurv\",\"title\":\"Lightbox\",\"tab\":\"style\"},{\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"id\":\"cat_style_fvicjn1e\",\"title\":\"Navigation\",\"tab\":\"style\"}]}',3,1,NULL,'{\"config\":{\"tgi_gallery_width\":\"900\",\"tgi_tile_width\":\"180\",\"tgi_tile_height\":\"150\",\"tgi_grid_padding\":\"10\",\"tgi_grid_num_rows\":\"2\",\"tgi_space_between_cols\":\"30\",\"tgi_space_between_rows\":\"30\",\"tgi_enable_border_unite_selected_text\":\"True\",\"tgi_enable_border\":\"true\",\"tgi_border_color\":\"#111111\",\"tgi_enable_outline_unite_selected_text\":\"True\",\"tgi_enable_outline\":\"true\",\"tgi_outline_color\":\"#f1f1f1\",\"tgi_overlay_opacity\":\"0.6\",\"tgi_theme_navigation_type_unite_selected_text\":\"Bullets\",\"tgi_theme_navigation_type\":\"bullets\",\"tgi_bullets_margin_top\":\"40\",\"tgi_bullets_space_between\":\"10\",\"tgi_enable_textpanel_unite_selected_text\":\"True\",\"tgi_enable_textpanel\":\"true\",\"tgi_textpanel_bg_color\":\"#000000\",\"tgi_textpanel_title_color\":\"#ffffff\",\"tgi_textpanel_title_text_align_unite_selected_text\":\"Center\",\"tgi_textpanel_title_text_align\":\"center\",\"bullets_color_unite_selected_text\":\"gray\",\"bullets_color\":\"gray\",\"thumb_quality_unite_selected_text\":\"Thumbnail\",\"thumb_quality\":\"thumb\"},\"items\":[{\"title\":\"gallery1\",\"image\":\"[url_assets]\\/gallery1.jpg\",\"description\":\"\",\"thumb\":\"[url_assets]\\/blox_thumbs\\/gallery1_300x100000.jpg\"},{\"title\":\"gallery2\",\"image\":\"[url_assets]\\/gallery2.jpg\",\"description\":\"\",\"thumb\":\"[url_assets]\\/blox_thumbs\\/gallery2_300x100000.jpg\"},{\"title\":\"gallery3\",\"image\":\"[url_assets]\\/gallery3.jpg\",\"description\":\"\",\"thumb\":\"[url_assets]\\/blox_thumbs\\/gallery3_300x100000.jpg\"},{\"title\":\"gallery1\",\"image\":\"[url_assets]\\/gallery1.jpg\",\"description\":\"\",\"thumb\":\"[url_assets]\\/blox_thumbs\\/gallery1_300x100000.jpg\"},{\"title\":\"gallery2\",\"image\":\"[url_assets]\\/gallery2.jpg\",\"description\":\"\",\"thumb\":\"[url_assets]\\/blox_thumbs\\/gallery2_300x100000.jpg\"},{\"title\":\"gallery3\",\"image\":\"[url_assets]\\/gallery3.jpg\",\"description\":\"\",\"thumb\":\"[url_assets]\\/blox_thumbs\\/gallery3_300x100000.jpg\"}],\"fonts\":{\"uc_items_attribute_title\":{\"color\":\"#ffffff\"}}}',NULL),(5,'Text Rotator','text_rotator_elementor','text_rotator','elementor','',1,'{\"html\":\"<div style=\\\"text-align:{{align}};\\\" id=\\\"{{uc_id}}\\\">\\n  <span class=\\\"string beginning_text_typography\\\" >{{beginning_text|raw}}<\\/span> \\n  <span class=\\\"string\\\">\\n    <span class=\\\"js-rotating middle_text_typography\\\">\\n        {% if random == \\\"true\\\" %}\\n            {{put_items(\\\"shuffle\\\")}}  \\n        {% else %}\\n            {{put_items()}}  \\n        {% endif %}\\n    <\\/span>\\n  <\\/span> \\n  <span class=\\\"string ending_text_typography\\\">{{ending_text|raw}}<\\/span>\\n<\\/div>\",\"html_item\":\"{% if item.item_index > 1 %}\\n<span style=\\\"display: none;\\\">{% if item.item_index > 1 %},{% endif %} {{item.title|raw}}<\\/span>\\n{% else %}\\n{% if item.item_index > 1 %},{% endif %} {{item.title|raw}}\\n{% endif %}\",\"css\":\"#{{uc_id}} span.string\\n{\\n  display:{{display}};\\n} \\n\\n{{put_font_override(\'middle_text_typography\',\'.middle_text_typography\',true)}}\",\"js\":\"jQuery(document).ready(function(){\\n  \\n  \\tvar objText = jQuery(\'#{{uc_id}} .js-rotating\');\\n  \\tvar strJson = {{put_items_json()}};\\n    var arrItems = JSON.parse(strJson);\\n\\n\\tobjText.Morphext({\\n    \\/\\/ The [in] animation type. Refer to Animate.css for a list of available animations.\\n    animation: \\\"{{effect}}\\\",\\n    \\/\\/ An array of phrases to rotate are created based on this separator. Change it if you wish to separate the phrases differently (e.g. So Simple | Very Doge | Much Wow | Such Cool).\\n    separator: \\\",\\\",\\n    \\/\\/ The delay between the changing of each phrase in milliseconds.\\n    speed: {{speed}},\\n    \\/\\/ An array of item otions                 \\n    arrItems: arrItems,                 \\n    complete: function () {\\n        \\/\\/ Called after the entrance animation is executed.\\n     \\n    }\\n});\\n\\n\\t\\n\\n});\"}','{\"options\":{\"enable_items\":\"true\",\"items_section_title\":\"\",\"items_section_heading\":\"\",\"path_assets\":\"Text Rotator\",\"js_as_module\":false,\"addon_icon\":\"fas fa-font\",\"dynamic_addon\":\"false\",\"dynamic_post_enable_customfields\":\"false\",\"dynamic_post_enable_category\":\"false\",\"description\":\"\",\"link_resource\":\"https:\\/\\/youtu.be\\/U5BAhHHUjEE\",\"link_preview\":\"https:\\/\\/unlimited-elements.com\\/text-rotator-for-elementor-page-builder\\/\",\"show_small_icon\":\"true\",\"preview_size_unite_selected_text\":\"Full Size\",\"preview_size\":\"full\",\"preview_custom_width\":\"\",\"preview_bgcol\":\"#ffffff\",\"special\":\"\",\"special_data\":\"\",\"is_free_addon\":true,\"is_new_addon\":false,\"is_last_updated\":false,\"is_trending\":false},\"params\":[{\"type\":\"uc_textfield\",\"title\":\"Beginning Text\",\"name\":\"beginning_text\",\"default_value\":\"Welcome to my\",\"font_editable\":\"false\",\"value\":\"Welcome to my\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_textfield\",\"title\":\"Ending Text\",\"name\":\"ending_text\",\"default_value\":\"Website\",\"font_editable\":\"false\",\"value\":\"Website\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Align\",\"name\":\"align\",\"options\":{\"Center\":\"center\",\"Left\":\"left\",\"Right\":\"right\"},\"default_value\":\"center\",\"value\":\"center\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Effect\",\"name\":\"effect\",\"options\":{\"Bounce In\":\"bounceIn\",\"Bounce\":\"bounce\",\"Flash\":\"flash\",\"Pulse\":\"pulse\",\"Rubber Band\":\"rubberBand\",\"Shake\":\"shake\",\"Swing\":\"swing\",\"Tada\":\"tada\",\"Wobble\":\"wobble\",\"Jello\":\"jello\",\"Heart Beat\":\"heartBeat\",\"bounceInDown\":\"bounceInDown\",\"bounceInLeft\":\"bounceInLeft\",\"bounceInRight\":\"bounceInRight\",\"bounceInUp\":\"bounceInUp\",\"fadeIn\":\"fadeIn\",\"fadeInDown\":\"fadeInDown\",\"fadeInDownBig\":\"fadeInDownBig\",\"fadeInLeft\":\"fadeInLeft\",\"fadeInLeftBig\":\"fadeInLeftBig\",\"fadeInRight\":\"fadeInRight\",\"fadeInRightBig\":\"fadeInRightBig\",\"fadeInUp\":\"fadeInUp\",\"fadeInUpBig\":\"fadeInUpBig\",\"flip\":\"flip\",\"flipInX\":\"flipInX\",\"flipInY\":\"flipInY\",\"lightSpeedIn\":\"lightSpeedIn\",\"rotateIn\":\"rotateIn\",\"rotateInDownLeft\":\"rotateInDownLeft\",\"rotateInDownRight\":\"rotateInDownRight\",\"rotateInUpLeft\":\"rotateInUpLeft\",\"rotateInUpRight\":\"rotateInUpRight\",\"slideInUp\":\"slideInUp\",\"slideInDown\":\"slideInDown\",\"slideInLeft\":\"slideInLeft\",\"slideInRight\":\"slideInRight\",\"zoomIn\":\"zoomIn\",\"zoomInDown\":\"zoomInDown\",\"zoomInLeft\":\"zoomInLeft\",\"zoomInRight\":\"zoomInRight\",\"zoomInUp\":\"zoomInUp\"},\"default_value\":\"bounceIn\",\"value\":\"bounceIn\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_number\",\"title\":\"Speed\",\"name\":\"speed\",\"default_value\":\"2000\",\"unit\":\"\",\"unit_custom\":\"\",\"value\":\"2000\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Display\",\"name\":\"display\",\"options\":{\"Inline\":\"inline\",\"Block\":\"block\"},\"default_value\":\"inline\",\"value\":\"inline\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_colorpicker\",\"title\":\"Beginning Text Color\",\"name\":\"beginning_text_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\".beginning_text_typography\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_hov24x0s\"},{\"type\":\"uc_colorpicker\",\"title\":\"Ending Text Color\",\"name\":\"ending_text_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\".ending_text_typography\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_i6jiq6oi\"},{\"type\":\"uc_typography\",\"title\":\"Beginning Text Typography\",\"name\":\"beginning_text_typography\",\"selector1\":\".beginning_text_typography\",\"selector2\":\"\",\"selector3\":\"\",\"value\":\"\",\"__attr_catid__\":\"cat_style_hov24x0s\"},{\"type\":\"uc_colorpicker\",\"title\":\"Middle Text Color\",\"name\":\"middle_text_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"#000000\",\"selector\":\".middle_text_typography\",\"selector_value\":\"color: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_1h8skx0t\"},{\"type\":\"uc_typography\",\"title\":\"Middle Text Typography\",\"name\":\"middle_text_typography\",\"selector1\":\".middle_text_typography\",\"selector2\":\"\",\"selector3\":\"\",\"value\":\"\",\"__attr_catid__\":\"cat_style_1h8skx0t\"},{\"type\":\"uc_typography\",\"title\":\"Ending Text Typography\",\"name\":\"ending_text_typography\",\"selector1\":\".ending_text_typography\",\"selector2\":\"\",\"selector3\":\"\",\"value\":\"\",\"__attr_catid__\":\"cat_style_i6jiq6oi\"},{\"type\":\"uc_radioboolean\",\"title\":\"Random Order\",\"name\":\"random\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"}],\"params_items\":[{\"type\":\"uc_textfield\",\"title\":\"Middle Text\",\"name\":\"title\",\"default_value\":\"Awesome\",\"font_editable\":\"false\"},{\"type\":\"uc_colorpicker\",\"title\":\"Color Override\",\"name\":\"color_override\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\"}],\"includes\":{\"js\":[{\"url\":\"Text Rotator\\/morphext.js\",\"condition\":null,\"params\":null}],\"jslib\":[\"jquery\"],\"css\":[{\"url\":\"Text Rotator\\/morphext.css\",\"condition\":null,\"params\":null},{\"url\":\"Text Rotator\\/animate.css\",\"condition\":null,\"params\":null}]},\"variables_item\":[],\"variables_main\":[],\"params_cats\":[{\"id\":\"cat_general_general\",\"title\":\"General\",\"tab\":\"content\"},{\"id\":\"cat_style_hov24x0s\",\"title\":\"Beginning Text\",\"tab\":\"style\"},{\"id\":\"cat_style_1h8skx0t\",\"title\":\"Rotating Text\",\"tab\":\"style\"},{\"id\":\"cat_style_i6jiq6oi\",\"title\":\"Ending Text\",\"tab\":\"style\"}]}',4,1,NULL,'{\"config\":{\"beginning_text\":\"Welcome to my\",\"ending_text\":\"Website\"},\"items\":[{\"title\":\"Awesome\"},{\"title\":\"Amazing\"},{\"title\":\"Responsive\"}]}',NULL),(6,'Card Carousel','card_carousel_elementor','card_carousel','elementor','Use the card carousel widget to display two or more pieces of content in a carousel format. Create any kind of carousel you can think about.',1,'{\"html\":\"<div class=\\\"uc_classic_carousel\\\" >\\n        <div class=\\\"uc_carousel owl-carousel {{remote_parent.class}}\\\" id=\\\"{{uc_id}}\\\" {{remote_parent.attributes|raw}}>\\n          \\t{{put_items()}}\\n      <\\/div>\\n<\\/div>\",\"html_item\":\"<div class=\\\"uc_classic_carousel_container_holder ue-item {{item.item_repeater_class}}\\\">\\n  <div class=\\\"ue-carousel-item\\\">\\n  {% if show_top_decoration == \\\"true\\\" %}<span class=\\\"uc_classic_carousel_border\\\" style=\\\"\\\"><\\/span>{% endif %}\\n  {% if show_image == \\\"true\\\" %}\\n  <div class=\\\"uc_classic_carousel_placeholder\\\">\\n    {% if image_link == \\\"true\\\" %}<a href=\\\"{{item.link}}\\\" title=\\\"{{item.btn_text}}\\\" {{item.link_html_attributes|raw}}>{% endif %}\\n      <img src=\\\"{{item.image}}\\\" {{item.image_attributes|raw}}>\\n    {% if image_link == \\\"true\\\" %}<\\/a>{% endif %}\\n  <\\/div>\\n  {% endif %}\\n  <div class=\\\"uc_classic_carousel_content\\\" style=\\\"direction:{{direction}};\\\">\\n    \\n    \\n    {% if show_icon == \\\"true\\\" %}\\n      <div class=\\\"ue-item-icon-wrapper\\\">\\n         <div class=\\\"ue-item-icon\\\">{{item.icon_html|raw}}<\\/div>\\n      <\\/div>\\n    {% endif %}\\n    \\n    {% if show_title == \\\"above\\\" %}\\n      {% if title_link == \\\"true\\\" %}<a href=\\\"{{item.link}}\\\" {{item.link_html_attributes|raw}}>{% endif %}\\t\\n      <{{title_html_tag}}  class=\\\"card_carousel_title\\\">{{item.title|raw}}<\\/{{title_html_tag}}>\\n      {% if title_link == \\\"true\\\" %}<\\/a>{% endif %}\\n    {% endif %}\\t\\n    \\n      \\n    {% if show_text == \\\"true\\\" %}<p class=\\\"card_carousel_text\\\">{{item.content|raw}}<\\/p>{% endif %}\\n    \\n    \\n    {% if show_title == \\\"under\\\" %}\\n      {% if title_link == \\\"true\\\" %}<a href=\\\"{{item.link}}\\\" {{item.link_html_attributes|raw}}>{% endif %}\\t\\n      <{{title_html_tag}}  class=\\\"card_carousel_title\\\">{{item.title|raw}}<\\/{{title_html_tag}}>\\n      {% if title_link == \\\"true\\\" %}<\\/a>{% endif %}\\n    {% endif %}\\t\\n    \\n    \\n    {% if show_button == \\\"true\\\" %}\\n\\t    <div class=\\\"ue_button\\\"><a class=\\\"uc_more_btn {{button_hover_animation}}\\\" href=\\\"{{item.link}}\\\" title=\\\"{{item.btn_text}}\\\" {{item.link_html_attributes|raw}}>{{item.btn_text|raw}}<\\/a><\\/div>\\n    {% endif %}\\t\\n  <\\/div>\\n  <\\/div>\\n<\\/div>\",\"css\":\"#{{uc_id}} *{\\n\\t-webkit-box-sizing: border-box;\\n\\t-moz-box-sizing: border-box;\\n\\tbox-sizing: border-box;\\n}\\n\\n#{{uc_id}} .ue-carousel-item\\n{\\n  overflow:hidden;\\n  transition:0.3s;\\n}\\n\\n#{{uc_id}} .uc_classic_carousel_container_holder\\n{\\n\\tdisplay:block;\\n\\tposition:relative;\\n\\twidth:100%;\\n    box-sizing: border-box;\\n}\\n.card_carousel_title\\n{\\n\\tfont-size:21px;\\n}\\n\\n.uc_classic_carousel .uc_classic_carousel_border\\n{\\n\\tdisplay:block;\\n    margin:0 auto;\\n}\\n\\n.uc_classic_carousel  .uc_classic_carousel_placeholder img\\n{\\n\\twidth:100%;\\n    \\n    display:inline-flex;\\n}\\n.uc_classic_carousel .uc_classic_carousel_content\\n{\\n  display: flex;\\n flex-flow: column nowrap;\\n}\\n\\n.uc_classic_carousel .ue_button\\n{\\n  margin-top:auto;\\n\\n}\\n\\n.uc_classic_carousel .uc_classic_carousel_content .uc_more_btn {\\n\\tdisplay:inline-block;\\n\\ttext-decoration:none;\\n\\ttransition: all 0.5s ease;\\n}\\n\\n\\n#{{uc_id}} .owl-dots {\\noverflow:hidden;\\ntext-align:{{dot_alignment}};\\n}\\n\\n#{{uc_id}} .owl-dot {\\nborder-radius:50%;\\ndisplay:inline-block;\\n}\\n\\n#{{uc_id}} .owl-nav .owl-prev{\\n    position:absolute;\\n    display:inline-block;\\n    text-align:center;\\n}\\n#{{uc_id}} .owl-nav .owl-next{\\n  position:absolute;\\n  display:inline-block;\\n  text-align:center;\\n}\\n\\n#{{uc_id}} .owl-nav .disabled\\n{\\n    display: none;  \\n}\\n\\n\\n#{{uc_id}} .ue-item-icon\\n{\\n  line-height:1em;\\n  display:inline-flex;\\n  justify-content:center;\\n  align-items:center;\\n  \\n}\\n\\n#{{uc_id}} .ue-item-icon svg\\n{\\n  height:1em;\\n  width:1em;\\n}\\n\\n#{{uc_id}} .ue-item-icon-wrapper\\n{\\n  display:flex;\\n}\\n\\n\\n{% if transition_easing == \\\"false\\\" %}\\n\\t#{{uc_id}} .owl-stage\\n        {\\n            transition-timing-function: linear!important;\\n        }\\n{% endif %}\",\"js\":\"jQuery(document).ready(function(){\\t\\nfunction {{uc_id}}_start(){\\n\\t\\t\\n  var objCarousel = jQuery(\'#{{uc_id}}\');\\n  \\n  \\t\\tobjCarousel.owlCarousel({\\n\\t\\t\\tloop: {{loop}},\\n            rtl:{{rtl}},\\n            autoplay:{{autoplay}},\\n            paddingType: \\\"{{stage_padding_type}}\\\",    \\n            autoplayHoverPause:{{autoplayhoverpause}},\\n            margin:{{margin_between_slides}},\\n            navText : [\\\"{{left_arrow_html|raw}}\\\",\\\"{{right_arrow_html|raw}}\\\"],\\n\\t\\t\\tnav: {{show_arrows}},\\n            rewindNav : false,\\n            center:{{center}},\\n            mouseDrag:{{mouse_drag}},\\n            touchDrag:{{touch_drag}},                    \\n\\t\\t\\tsetActiveClassOnMobile:{{active_on_mobile}},\\n            changeItemOnClick:{{scroll_on_click}},\\n            autoplayTimeout:{{autoplay_interval}},\\n            smartSpeed: {{transition_speed}},  \\n\\t\\t\\tdots:{{show_bullets}},\\n            shuffle:{{shuffle}},\\n            scrollToHead:{{scroll_to_head}},\\n            scrollToHeadOffset: {{scroll_to_head_offset}},                    \\n\\t\\t\\tresponsive: {\\n\\t\\t\\t \\n                   0 : {\\n\\t\\t\\t\\t\\t\\titems:{{number_of_items_mobile}},\\n                        slideBy: {{slides_to_scroll_mobile}},\\n                         \\n                        {% if stage_padding_type != \\\"none\\\" %}\\n                             stagePadding: {{stage_padding_mobile}},\\n                        {% endif %}\\t        \\n\\t\\t\\t\\t\\t},\\n\\t\\t\\t\\t\\t768 : {\\n\\t\\t\\t\\t\\t\\titems:{{number_of_items_tablet}},\\n                        slideBy: {{slides_to_scroll_tablet}},\\n                         \\n                        {% if stage_padding_type != \\\"none\\\" %}\\n                             stagePadding: {{stage_padding_tablet}},\\n                        {% endif %}\\t        \\n\\t\\t\\t\\t\\t},\\n\\t\\t\\t\\t\\t980 : {\\n\\t\\t\\t\\t\\t\\titems:{{number_of_items}},\\n                        slideBy: {{slides_to_scroll}},\\n                         \\n                        {% if stage_padding_type != \\\"none\\\" %}\\n                             stagePadding: {{stage_padding}},\\n                        {% endif %}\\t        \\n\\t\\t\\t\\t\\t}  \\n\\t\\t\\t}\\n\\t\\t  });\\n  \\n  \\n\\t\\t{{ucfunc(\\\"put_remote_parent_js\\\",\\\"objCarousel\\\")}}  \\n  \\n}if(jQuery(\\\"#{{uc_id}}\\\").length) {{uc_id}}_start();\\n\\tjQuery( document ).on( \'elementor\\/popup\\/show\', (event, id, objPopup) => { \\n\\tif(objPopup.$element.has(jQuery(\\\"#{{uc_id}}\\\")).length) {{uc_id}}_start();});\\t\\n});\"}','{\"options\":{\"enable_items\":\"true\",\"items_section_title\":\"\",\"items_section_heading\":\"\",\"path_assets\":\"uc_classic_carousel\",\"js_as_module\":false,\"addon_icon\":\"fas fa-arrows-alt-h\",\"dynamic_addon\":\"false\",\"dynamic_post_enable_customfields\":\"false\",\"dynamic_post_enable_category\":\"false\",\"description\":\"Use the card carousel widget to display two or more pieces of content in a carousel format. Create any kind of carousel you can think about.\",\"link_resource\":\"https:\\/\\/youtu.be\\/hOkFaSpUHk0\",\"link_preview\":\"https:\\/\\/unlimited-elements.com\\/card-carousel-widget-for-elementor\\/\",\"show_small_icon\":\"true\",\"preview_size_unite_selected_text\":\"Full Size\",\"preview_size\":\"full\",\"preview_custom_width\":\"\",\"preview_bgcol\":\"#ffffff\",\"special\":\"\",\"is_free_addon\":true,\"is_new_addon\":false,\"is_last_updated\":false,\"is_trending\":false},\"params\":[{\"type\":\"uc_radioboolean\",\"title\":\"Loop\",\"name\":\"loop\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\",\"value\":\"true\"},{\"type\":\"uc_number\",\"title\":\"Number of items\",\"name\":\"number_of_items\",\"description\":\"\",\"default_value\":\"3\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"1\",\"max_value\":\"10\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"2\",\"default_value_mobile\":\"1\",\"selector\":\"\",\"selector_value\":\"\",\"__attr_catid__\":\"cat_general_general\",\"value\":\"3\",\"value_tablet\":\"2\",\"value_mobile\":\"1\"},{\"type\":\"uc_number\",\"title\":\"Slides To Scroll\",\"name\":\"slides_to_scroll\",\"description\":\"Don\'t leave empty\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"1\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"1\",\"default_value_mobile\":\"1\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_number\",\"title\":\"Transition Speed\",\"name\":\"transition_speed\",\"description\":\"\",\"default_value\":\"1000\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"__attr_catid__\":\"cat_general_general\",\"value\":\"1000\"},{\"type\":\"uc_number\",\"title\":\"Margin between slides\",\"name\":\"margin_between_slides\",\"description\":\"\",\"default_value\":\"30\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"__attr_catid__\":\"cat_general_general\",\"value\":\"30\"},{\"type\":\"uc_dropdown\",\"title\":\"Stage Padding Type\",\"name\":\"stage_padding_type\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"None\":\"none\",\"Both\":\"both\",\"Left\":\"left\",\"Right\":\"right\"},\"default_value\":\"none\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"php_filter_name\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_number\",\"title\":\"Stage Padding\",\"name\":\"stage_padding\",\"description\":\"To create offset on sides\",\"enable_condition\":true,\"condition_attribute\":\"stage_padding_type\",\"condition_operator\":\"not_equal\",\"condition_value\":[\"none\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"0\",\"default_value_mobile\":\"0\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Autoplay\",\"name\":\"autoplay\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\",\"value\":\"true\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Arrows \",\"name\":\"show_arrows\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\",\"value\":\"true\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Bullets\",\"name\":\"show_bullets\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_number\",\"title\":\"Autoplay Interval\",\"name\":\"autoplay_interval\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"autoplay\",\"condition_operator\":\"equal\",\"condition_value\":\"true\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"3000\",\"unit\":\"\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Autoplay Hover Pause\",\"name\":\"autoplayhoverpause\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"autoplay\",\"condition_operator\":\"equal\",\"condition_value\":\"true\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_dropdown\",\"title\":\"Align\",\"name\":\"align\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"options\":{\"Center\":\"center\",\"Left\":\"left\",\"Right\":\"right\",\"Justify\":\"justify\"},\"default_value\":\"center\",\"selector\":\".ue-carousel-item\",\"selector_value\":\"text-align:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_slider\",\"title\":\"Title Spacing\",\"name\":\"title_spacing\",\"description\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".card_carousel_title\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_aohl5oww\",\"value\":\"0\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_slider\",\"title\":\"Text Spacing\",\"name\":\"text_spacing\",\"description\":\"\",\"default_value\":\"10\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".card_carousel_text\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_lhmeogkk\",\"value\":\"10\"},{\"type\":\"uc_typography\",\"title\":\"Button Typography\",\"name\":\"button_typography\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"selector1\":\".uc_more_btn\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_ubiljccp\"},{\"type\":\"uc_hover_animations\",\"title\":\"Button Hover Animation\",\"name\":\"button_hover_animation\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"\",\"__attr_catid__\":\"cat_style_ubiljccp\"},{\"type\":\"uc_padding\",\"title\":\"Button Padding\",\"name\":\"button_padding\",\"description\":\"\",\"is_responsive\":false,\"desktop_top\":\"10\",\"desktop_right\":\"20\",\"desktop_bottom\":\"10\",\"desktop_left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".uc_more_btn\",\"__attr_catid__\":\"cat_style_ubiljccp\",\"value\":{\"top\":\"10\",\"right\":\"20\",\"bottom\":\"10\",\"left\":\"20\",\"unit\":\"px\"}},{\"type\":\"uc_slider\",\"title\":\"Button Radius\",\"name\":\"button_radius\",\"description\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_more_btn\",\"selector_value\":\"border-radius: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_ubiljccp\",\"value\":\"5\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Background Color\",\"name\":\"button_bg_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"#d3d3d3\",\"selector\":\".uc_more_btn\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_ubiljccp\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Background Color Hover\",\"name\":\"button_background_color_hover\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".uc_more_btn:hover\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_ubiljccp\",\"value\":\"#000000\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Text Color\",\"name\":\"btn_txt_clr\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".uc_more_btn\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_ubiljccp\",\"value\":\"#000000\"},{\"type\":\"uc_colorpicker\",\"title\":\"Button Text Color Hover\",\"name\":\"btn_txt_clr_hvr\",\"description\":\"\",\"default_value\":\"#ffffff\",\"selector\":\".uc_more_btn:hover\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_ubiljccp\",\"value\":\"#ffffff\"},{\"type\":\"uc_radioboolean\",\"title\":\"Text Direction\",\"name\":\"direction\",\"description\":\"\",\"admin_label\":\"false\",\"default_value\":\"ltr\",\"true_name\":\"ltr\",\"true_value\":\"ltr\",\"false_name\":\"rtl\",\"false_value\":\"rtl\",\"__attr_catid__\":\"cat_general_general\",\"value\":\"ltr\"},{\"type\":\"uc_slider\",\"title\":\"Image Radius\",\"name\":\"image_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_classic_carousel_placeholder img\",\"selector_value\":\"border-radius: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_bx9jev04\"},{\"type\":\"uc_slider\",\"title\":\"Image Height\",\"name\":\"image_height\",\"description\":\"\",\"default_value\":\"200\",\"min\":\"1\",\"max\":\"500\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_classic_carousel_placeholder img\",\"selector_value\":\"height: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_bx9jev04\",\"value\":\"200\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_slider\",\"title\":\"Image Width\",\"name\":\"image_width\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"\",\"min\":\"0\",\"max\":\"500\",\"step\":\"1\",\"units\":\"px_percent\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_classic_carousel_placeholder img\",\"selector_value\":\"width: {{SIZE}}{{UNIT}} !important;\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_bx9jev04\"},{\"type\":\"uc_slider\",\"title\":\"Nav Dots Size\",\"name\":\"nav_dots_size\",\"description\":\"\",\"default_value\":\"8\",\"min\":\"4\",\"max\":\"20\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-dot\",\"selector_value\":\"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_r94csez3\",\"value\":\"8\"},{\"type\":\"uc_colorpicker\",\"title\":\"Dot Color\",\"name\":\"dot_color\",\"description\":\"\",\"default_value\":\"#c6c6c6\",\"selector\":\".owl-dot\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_r94csez3\",\"value\":\"#c6c6c6\"},{\"type\":\"uc_colorpicker\",\"title\":\"Dot Active Color\",\"name\":\"dot_active_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".owl-dot.active\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_r94csez3\",\"value\":\"#000000\"},{\"type\":\"uc_slider\",\"title\":\"Dot Spacing\",\"name\":\"dot_spacing\",\"description\":\"\",\"default_value\":\"20\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-dots\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_r94csez3\",\"value\":\"20\"},{\"type\":\"uc_slider\",\"title\":\"Dot Space Between\",\"name\":\"dot_space_between\",\"description\":\"\",\"default_value\":\"5\",\"min\":\"1\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":\"false\",\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-dot\",\"selector_value\":\"margin:0px {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_r94csez3\",\"value\":\"5\"},{\"type\":\"uc_dropdown\",\"title\":\"Dot Alignment\",\"name\":\"dot_alignment\",\"description\":\"\",\"options\":{\"Center\":\"center\",\"Left\":\"left\",\"Right\":\"right\"},\"default_value\":\"center\",\"__attr_catid__\":\"cat_style_r94csez3\",\"value\":\"center\"},{\"type\":\"uc_padding\",\"title\":\"Image Padding\",\"name\":\"image_padding\",\"description\":\"\",\"is_responsive\":true,\"desktop_top\":\"20\",\"desktop_right\":\"20\",\"desktop_bottom\":\"20\",\"desktop_left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".uc_classic_carousel_placeholder\",\"__attr_catid__\":\"cat_style_bx9jev04\",\"value\":{\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"}},{\"type\":\"uc_colorpicker\",\"title\":\"Background Color\",\"name\":\"background_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"#ffffff\",\"selector\":\".ue-carousel-item\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_colorpicker\",\"title\":\"Top Decoration Color\",\"name\":\"top_decoration_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".uc_classic_carousel_border\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_vtg2vocz\",\"value\":\"#000000\"},{\"type\":\"uc_radioboolean\",\"title\":\"Transition Easing\",\"name\":\"transition_easing\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Center\",\"name\":\"center\",\"description\":\"\",\"enable_condition\":\"false\",\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":\"\",\"label_block\":\"false\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_slider\",\"title\":\"Top Decoration Width\",\"name\":\"top_decoration_width\",\"description\":\"\",\"default_value\":\"50\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_classic_carousel_border\",\"selector_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vtg2vocz\",\"value\":\"50\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_slider\",\"title\":\"Top Decoration Height\",\"name\":\"top_decoration_height\",\"description\":\"\",\"default_value\":\"3\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_classic_carousel_border\",\"selector_value\":\"height: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vtg2vocz\",\"value\":\"3\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_padding\",\"title\":\"Content Padding\",\"name\":\"content_padding\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"is_responsive\":true,\"desktop_top\":\"0\",\"desktop_right\":\"20\",\"desktop_bottom\":\"20\",\"desktop_left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".uc_classic_carousel_content\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_colorpicker\",\"title\":\"Title Color\",\"name\":\"title_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".card_carousel_title\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_aohl5oww\",\"value\":\"#000000\"},{\"type\":\"uc_typography\",\"title\":\"Title Typography\",\"name\":\"title_typography\",\"description\":\"\",\"selector1\":\".card_carousel_title\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_aohl5oww\",\"value\":\"\"},{\"type\":\"uc_colorpicker\",\"title\":\"Text Color\",\"name\":\"text_color\",\"description\":\"\",\"default_value\":\"#8a8a8a\",\"selector\":\".card_carousel_text\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_lhmeogkk\",\"value\":\"#8a8a8a\"},{\"type\":\"uc_typography\",\"title\":\"Text Typography\",\"name\":\"text_typography\",\"description\":\"\",\"selector1\":\".card_carousel_text\",\"selector2\":\"\",\"selector3\":\"\",\"__attr_catid__\":\"cat_style_lhmeogkk\",\"value\":\"\"},{\"type\":\"uc_slider\",\"title\":\"Button Spacing\",\"name\":\"button_spacing\",\"description\":\"\",\"default_value\":\"10\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_more_btn\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_ubiljccp\",\"value\":\"10\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_slider\",\"title\":\"Slide Radius\",\"name\":\"slide_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-carousel-item\",\"selector_value\":\"border-radius: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_slider\",\"title\":\"Nav Arrow Spacing\",\"name\":\"nav_arrow_spacing\",\"description\":\"Horizontal Spacing\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-nav .owl-prev\",\"selector_value\":\"left: {{SIZE}}{{UNIT}}; right: auto;\",\"show_more_selectors\":true,\"selector2\":\".owl-nav .owl-next\",\"selector2_value\":\"right: {{SIZE}}{{UNIT}}; left: auto;\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vp30mio9\"},{\"type\":\"uc_slider\",\"title\":\"Nav Arrow Position\",\"name\":\"nav_arrow_position\",\"description\":\"Vertical Spacing\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"94\",\"min\":\"0\",\"max\":\"600\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-carousel .owl-nav .owl-next, .owl-carousel .owl-nav .owl-prev\",\"selector_value\":\"top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vp30mio9\"},{\"type\":\"uc_slider\",\"title\":\"Nav Arrow Radius\",\"name\":\"nav_arrow_radius\",\"description\":\"\",\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-carousel .owl-nav .owl-next, .owl-carousel .owl-nav .owl-prev\",\"selector_value\":\"border-radius: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"0\"},{\"type\":\"uc_slider\",\"title\":\"Nav Arrow Background Size\",\"name\":\"nav_arrow_background_size\",\"description\":\"\",\"default_value\":\"62\",\"min\":\"20\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-carousel .owl-nav .owl-next, .owl-carousel .owl-nav .owl-prev\",\"selector_value\":\"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}}; line-height: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"42\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_slider\",\"title\":\"Nav Arrow Icon Size\",\"name\":\"nav_arrow_icon_size\",\"description\":\"\",\"default_value\":\"24\",\"min\":\"20\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".owl-carousel .owl-nav .owl-next, .owl-carousel .owl-nav .owl-prev\",\"selector_value\":\"font-size: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"24\",\"value_tablet\":\"\",\"value_mobile\":\"\"},{\"type\":\"uc_colorpicker\",\"title\":\"Nav Arrow Background\",\"name\":\"nav_arrow_background\",\"description\":\"\",\"default_value\":\"#ffffff\",\"selector\":\".owl-carousel .owl-nav .owl-next, .owl-carousel .owl-nav .owl-prev\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"#ffffff\"},{\"type\":\"uc_colorpicker\",\"title\":\"Nav Arrow Background Hover\",\"name\":\"nav_arrow_background_hover\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".owl-carousel .owl-nav .owl-next:hover, .owl-carousel .owl-nav .owl-prev:hover\",\"selector_value\":\"background-color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"#000000\"},{\"type\":\"uc_colorpicker\",\"title\":\"Nav Arrow Icon Color\",\"name\":\"nav_arrow_icon_color\",\"description\":\"\",\"default_value\":\"#000000\",\"selector\":\".owl-carousel .owl-nav .owl-next, .owl-carousel .owl-nav .owl-prev\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"#000000\"},{\"type\":\"uc_colorpicker\",\"title\":\"Nav Arrow Icon Color Hover\",\"name\":\"nav_arrow_icon_color_hover\",\"description\":\"\",\"default_value\":\"#ffffff\",\"selector\":\".owl-carousel .owl-nav .owl-next:hover, .owl-carousel .owl-nav .owl-prev:hover\",\"selector_value\":\"color:{{VALUE}};\",\"__attr_catid__\":\"cat_style_vp30mio9\",\"value\":\"#ffffff\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Image\",\"name\":\"show_image\",\"description\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_radioboolean\",\"title\":\"Image Link\",\"name\":\"image_link\",\"description\":\"Makes image use link field\",\"enable_condition\":true,\"condition_attribute\":\"show_image\",\"condition_operator\":\"equal\",\"condition_value\":\"true\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Icon\",\"name\":\"show_icon\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_dropdown\",\"title\":\"Show Title\",\"name\":\"show_title\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"options\":{\"Hide\":\"hide\",\"Above Content\":\"above\",\"Under Content\":\"under\"},\"default_value\":\"above\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_dropdown\",\"title\":\"Title HTML Tag\",\"name\":\"title_html_tag\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"show_title\",\"condition_operator\":\"not_equal\",\"condition_value\":\"hide\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"div\":\"div\",\"h1\":\"h1\",\"h2\":\"h2\",\"h3\":\"h3\",\"h4\":\"h4\",\"h5\":\"h5\",\"h6\":\"h6\"},\"default_value\":\"div\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_radioboolean\",\"title\":\"Title Link\",\"name\":\"title_link\",\"description\":\"Makes the title linkable\",\"enable_condition\":true,\"condition_attribute\":\"show_title\",\"condition_operator\":\"not_equal\",\"condition_value\":\"hide\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Text\",\"name\":\"show_text\",\"description\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Button\",\"name\":\"show_button\",\"description\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\",\"value\":\"true\"},{\"type\":\"uc_slider\",\"title\":\"Content Minimum Height\",\"name\":\"content_minimum_height\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"\",\"min\":\"0\",\"max\":\"1000\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc_classic_carousel_content\",\"selector_value\":\"min-height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_boxshadow\",\"title\":\"Item Shadow\",\"name\":\"item_shadow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"selector\":\".ue-carousel-item\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_border\",\"title\":\"Item Border\",\"name\":\"item_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"border_type\":\"solid\",\"border_color\":\"#dfdfdf\",\"width_desktop_top\":\"1\",\"width_desktop_right\":\"1\",\"width_desktop_bottom\":\"1\",\"width_desktop_left\":\"1\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue-carousel-item\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_radioboolean\",\"title\":\"Show Top Decoration\",\"name\":\"show_top_decoration\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"__attr_catid__\":\"cat_content_h40uqlsb\"},{\"type\":\"uc_margins\",\"title\":\"Item Margin\",\"name\":\"item_margin\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"is_responsive\":true,\"desktop_top\":\"\",\"desktop_right\":\"\",\"desktop_bottom\":\"\",\"desktop_left\":\"\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-carousel-item\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_slider\",\"title\":\"Item Scale\",\"name\":\"item_scale\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"default_value\":\"1\",\"min\":\"0\",\"max\":\"1\",\"step\":\"0.1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-carousel-item\",\"selector_value\":\"transform: scale({{SIZE}},{{SIZE}});\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_border\",\"title\":\"Button Border\",\"name\":\"button_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".uc_more_btn\",\"__attr_catid__\":\"cat_style_ubiljccp\"},{\"type\":\"uc_border\",\"title\":\"Button Border Hover\",\"name\":\"button_border_hover\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".uc_more_btn:hover\",\"__attr_catid__\":\"cat_style_ubiljccp\"},{\"type\":\"uc_icon_library\",\"title\":\"Left Arrow\",\"name\":\"left_arrow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"fas fa-chevron-left\",\"enable_svg\":false,\"put_svg_as\":\"image\",\"__attr_catid__\":\"cat_content_esf09cqe\"},{\"type\":\"uc_icon_library\",\"title\":\"Right Arrow\",\"name\":\"right_arrow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"fas fa-chevron-right\",\"enable_svg\":false,\"put_svg_as\":\"svg\",\"__attr_catid__\":\"cat_content_esf09cqe\"},{\"type\":\"uc_listing\",\"title\":\"Remote Parent\",\"name\":\"remote_parent\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"use_for\":\"remote\",\"gallery_enable_video\":false,\"enable_pagination\":false,\"remote_type\":\"parent\",\"remote_widget_name\":\"Icon Carousel\",\"__attr_catid__\":\"cat_content_vvdb29vi\"},{\"type\":\"uc_dropdown\",\"title\":\"Image Fit\",\"name\":\"image_fit\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Cover\":\"cover\",\"Contain\":\"contain\"},\"default_value\":\"cover\",\"selector\":\".uc_classic_carousel_placeholder img\",\"selector_value\":\"object-fit: {{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_bx9jev04\"},{\"type\":\"uc_css_filters\",\"title\":\"Item CSS Filter\",\"name\":\"item_css_filter\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Normal\",\"selector\":\".ue-carousel-item\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_colorpicker\",\"title\":\"Active Slide Background\",\"name\":\"active_slide_background\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Active\",\"default_value\":\"\",\"selector\":\".uc-active-item .ue-carousel-item\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_slider\",\"title\":\"Active Item Scale\",\"name\":\"active_item_scale\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Active\",\"default_value\":\"1\",\"min\":\"0\",\"max\":\"1\",\"step\":\"0.1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".uc-active-item .ue-carousel-item\",\"selector_value\":\"transform: scale({{SIZE}},{{SIZE}});\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_border\",\"title\":\"Active Item Border\",\"name\":\"active_item_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Active\",\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue-carousel-item\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_css_filters\",\"title\":\"Active Slide CSS Filter\",\"name\":\"active_slide_css_filter\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"Active\",\"selector\":\".uc-active-item .ue-carousel-item\",\"__attr_catid__\":\"cat_style_fhe0kmn5\"},{\"type\":\"uc_radioboolean\",\"title\":\"Set Active Mode On Mobile\",\"name\":\"active_on_mobile\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Change On Click\",\"name\":\"scroll_on_click\",\"description\":\"Change to the clicked item on item click.\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_slider\",\"title\":\"Icon Size Outter\",\"name\":\"icon_size_outter\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"60\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-item-icon\",\"selector_value\":\"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_slider\",\"title\":\"Icon Size\",\"name\":\"icon_size\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-item-icon\",\"selector_value\":\"font-size: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Icon Color\",\"name\":\"icon_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"#ffffff\",\"selector\":\".ue-item-icon\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":true,\"selector2\":\".ue-item-icon svg\",\"selector2_value\":\"fill:{{VALUE}};\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Icon Background\",\"name\":\"icon_background\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"#6e6e6e\",\"selector\":\".ue-item-icon\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Icon Radius\",\"name\":\"icon_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"is_responsive\":true,\"desktop_top\":\"100\",\"desktop_right\":\"100\",\"desktop_bottom\":\"100\",\"desktop_left\":\"100\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-item-icon\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_boxshadow\",\"title\":\"Icon Shadow\",\"name\":\"icon_shadow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"selector\":\".ue-item-icon\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_border\",\"title\":\"Icon Border\",\"name\":\"icon_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue-item-icon\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_slider\",\"title\":\"Icon Spacing\",\"name\":\"icon_spacing\",\"description\":\"Margin Top\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-item-icon\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_dropdown\",\"title\":\"Icon Alignment\",\"name\":\"icon_alignment\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"options\":{\"Start\":\"flex-start\",\"Center\":\"center\",\"End\":\"flex-end\"},\"default_value\":\"center\",\"selector\":\".ue-item-icon-wrapper\",\"selector_value\":\"justify-content:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_radioboolean\",\"title\":\"RTL\",\"name\":\"rtl\",\"description\":\"For right to left websites.\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Random Order\",\"name\":\"shuffle\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Mouse Drag\",\"name\":\"mouse_drag\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Touch Drag\",\"name\":\"touch_drag\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"true\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_radioboolean\",\"title\":\"Scroll To Head\",\"name\":\"scroll_to_head\",\"description\":\"scroll to head on item change if the carousel not visible\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"__attr_catid__\":\"cat_general_general\"},{\"type\":\"uc_number\",\"title\":\"Scroll To Head Offset\",\"name\":\"scroll_to_head_offset\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"scroll_to_head\",\"condition_operator\":\"equal\",\"condition_value\":[\"true\"],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"0\",\"unit\":\"px\",\"unit_custom\":\"\",\"min_value\":\"\",\"max_value\":\"\",\"step\":\"\",\"is_responsive\":false,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\"\",\"selector_value\":\"\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_general_general\"}],\"params_items\":[{\"type\":\"uc_textfield\",\"title\":\"Title\",\"name\":\"title\",\"description\":\"\",\"default_value\":\"Default Title\",\"font_editable\":false},{\"type\":\"uc_textarea\",\"title\":\"Content\",\"name\":\"content\",\"description\":\"\",\"default_value\":\"Lorem ipsum dolor sit amet, conse ctetur adipisicing elit, sed do eiusmod tempor incididunt ut...\",\"font_editable\":false},{\"type\":\"uc_textfield\",\"title\":\"Button Text\",\"name\":\"btn_text\",\"description\":\"\",\"default_value\":\"Show More\",\"font_editable\":false},{\"type\":\"uc_image\",\"title\":\"Image\",\"name\":\"image\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"media_type\":\"image\",\"default_value\":\"[url_assets]\\/uc_classic_carousel_img1.jpg\",\"add_image_sizes\":true,\"default_value_json\":\"\"},{\"type\":\"uc_link\",\"title\":\"Link\",\"name\":\"link\",\"description\":\"\",\"default_value\":\"#\"},{\"type\":\"uc_radioboolean\",\"title\":\"Override Colors\",\"name\":\"override_colors\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":null,\"condition_operator\":\"equal\",\"condition_value\":null,\"condition_attribute2\":null,\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"false\",\"true_name\":\"Yes\",\"true_value\":\"true\",\"false_name\":\"No\",\"false_value\":\"false\"},{\"type\":\"uc_colorpicker\",\"title\":\"Override Background\",\"name\":\"override_background\",\"description\":\"\",\"enable_condition\":true,\"condition_attribute\":\"override_colors\",\"condition_operator\":\"equal\",\"condition_value\":\"true\",\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"\",\"selector\":\"{{CURRENT_ITEM}} .ue-carousel-item\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\"},{\"type\":\"uc_icon_library\",\"title\":\"Icon\",\"name\":\"icon\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":[],\"condition_attribute2\":\"\",\"condition_operator2\":\"equal\",\"condition_value2\":null,\"label_block\":false,\"tabname\":\"\",\"default_value\":\"fas fa-rocket\",\"enable_svg\":true,\"put_svg_as\":\"svg\"}],\"includes\":{\"js\":[],\"jslib\":[\"jquery\",\"font-awsome\",\"owl-carousel-new\"],\"css\":[]},\"variables_item\":[],\"variables_main\":[],\"params_cats\":[{\"id\":\"cat_general_general\",\"title\":\"General\",\"tab\":\"content\"},{\"id\":\"cat_content_h40uqlsb\",\"title\":\"Layout\",\"tab\":\"content\"},{\"id\":\"cat_content_esf09cqe\",\"title\":\"Arrows\",\"tab\":\"content\"},{\"id\":\"cat_content_vvdb29vi\",\"title\":\"Connected Widgets Settings\",\"tab\":\"content\"},{\"id\":\"cat_style_fhe0kmn5\",\"title\":\"Slide\",\"tab\":\"style\"},{\"id\":\"cat_style_vtg2vocz\",\"title\":\"Top Decoration\",\"tab\":\"style\"},{\"id\":\"cat_style_bx9jev04\",\"title\":\"Image\",\"tab\":\"style\"},{\"params\":[{\"type\":\"uc_slider\",\"title\":\"Icon Size Outter\",\"name\":\"icon_size_outter\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"60\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-item-icon\",\"selector_value\":\"width: {{SIZE}}{{UNIT}}; height: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_slider\",\"title\":\"Icon Size\",\"name\":\"icon_size\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"20\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-item-icon\",\"selector_value\":\"font-size: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Icon Color\",\"name\":\"icon_color\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"#ffffff\",\"selector\":\".ue-item-icon\",\"selector_value\":\"color:{{VALUE}};\",\"show_more_selectors\":true,\"selector2\":\".ue-item-icon svg\",\"selector2_value\":\"fill:{{VALUE}};\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_colorpicker\",\"title\":\"Icon Background\",\"name\":\"icon_background\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"#6e6e6e\",\"selector\":\".ue-item-icon\",\"selector_value\":\"background-color:{{VALUE}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"\",\"selector3\":\"\",\"selector3_value\":\"\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_border_dimentions\",\"title\":\"Icon Radius\",\"name\":\"icon_radius\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"is_responsive\":true,\"desktop_top\":\"100\",\"desktop_right\":\"100\",\"desktop_bottom\":\"100\",\"desktop_left\":\"100\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"selector\":\".ue-item-icon\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_boxshadow\",\"title\":\"Icon Shadow\",\"name\":\"icon_shadow\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"selector\":\".ue-item-icon\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_border\",\"title\":\"Icon Border\",\"name\":\"icon_border\",\"description\":\"\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"border_type\":\"none\",\"border_color\":\"\",\"width_desktop_top\":\"\",\"width_desktop_right\":\"\",\"width_desktop_bottom\":\"\",\"width_desktop_left\":\"\",\"width_tablet_top\":\"\",\"width_tablet_right\":\"\",\"width_tablet_bottom\":\"\",\"width_tablet_left\":\"\",\"width_mobile_top\":\"\",\"width_mobile_right\":\"\",\"width_mobile_bottom\":\"\",\"width_mobile_left\":\"\",\"selector\":\".ue-item-icon\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"},{\"type\":\"uc_slider\",\"title\":\"Icon Spacing\",\"name\":\"icon_spacing\",\"description\":\"Margin Top\",\"enable_condition\":false,\"condition_attribute\":\"\",\"condition_operator\":\"equal\",\"condition_value\":null,\"label_block\":false,\"default_value\":\"0\",\"min\":\"0\",\"max\":\"100\",\"step\":\"1\",\"units\":\"px\",\"is_responsive\":true,\"default_value_tablet\":\"\",\"default_value_mobile\":\"\",\"selector\":\".ue-item-icon\",\"selector_value\":\"margin-top: {{SIZE}}{{UNIT}};\",\"show_more_selectors\":false,\"selector2\":\"\",\"selector2_value\":\"width: {{SIZE}}{{UNIT}};\",\"selector3\":\"\",\"selector3_value\":\"width: {{SIZE}}{{UNIT}};\",\"__attr_catid__\":\"cat_style_rgn3eqz4\"}],\"expire\":1643623349684,\"id\":\"cat_style_rgn3eqz4\",\"title\":\"Icon\",\"tab\":\"style\"},{\"id\":\"cat_style_aohl5oww\",\"title\":\"Title\",\"tab\":\"style\"},{\"id\":\"cat_style_lhmeogkk\",\"title\":\"Text\",\"tab\":\"style\"},{\"id\":\"cat_style_ubiljccp\",\"title\":\"Button\",\"tab\":\"style\"},{\"id\":\"cat_style_vp30mio9\",\"title\":\"Nav Arrows\",\"tab\":\"style\"},{\"id\":\"cat_style_r94csez3\",\"title\":\"Nav Bullets\",\"tab\":\"style\"}]}',5,1,NULL,'{\"config\":{\"loop\":\"true\",\"autoplay\":\"true\",\"show_arrows\":\"true\",\"show_bullets\":\"block\",\"number_of_items\":\"3\",\"number_of_items_tablet\":\"2\",\"number_of_items_mobile\":\"1\",\"align_unite_selected_text\":\"Center\",\"align\":\"center\",\"title_spacing\":\"0\",\"title_spacing_tablet\":\"\",\"title_spacing_mobile\":\"\",\"text_spacing\":\"10\",\"button_padding\":{\"top\":\"10\",\"right\":\"20\",\"bottom\":\"10\",\"left\":\"20\",\"unit\":\"px\"},\"button_radius\":\"5\",\"transition_speed\":\"1000\",\"autoplay_interval\":\"3000\",\"button_bg_color\":\"#ffffff\",\"button_background_color_hover\":\"#000000\",\"button_border_width\":\"2\",\"btn_brdr_clr\":\"#000000\",\"btn_brdr_clr_hover\":\"#000000\",\"btn_txt_clr\":\"#000000\",\"btn_txt_clr_hvr\":\"#ffffff\",\"item_shadow\":\"0px 5px 10px rgba(0, 0, 0, 0.1); \",\"item_brdr_clr\":\"#cdcdcd\",\"item_brdr_width\":\"0\",\"direction\":\"ltr\",\"margin_between_slides\":\"30\",\"image_radius\":\"0\",\"image_height\":\"200\",\"image_height_tablet\":\"\",\"image_height_mobile\":\"\",\"image_padding\":{\"top\":\"20\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"background_color\":\"#ffffff\",\"top_decoration_color\":\"#000000\",\"top_decoration_width\":\"50\",\"top_decoration_width_tablet\":\"\",\"top_decoration_width_mobile\":\"\",\"top_decoration_height\":\"3\",\"top_decoration_height_tablet\":\"\",\"top_decoration_height_mobile\":\"\",\"content_padding\":{\"top\":\"0\",\"right\":\"20\",\"bottom\":\"20\",\"left\":\"20\",\"tablet_top\":\"\",\"tablet_right\":\"\",\"tablet_bottom\":\"\",\"tablet_left\":\"\",\"mobile_top\":\"\",\"mobile_right\":\"\",\"mobile_bottom\":\"\",\"mobile_left\":\"\",\"unit\":\"px\"},\"title_color\":\"#000000\",\"text_color\":\"#8a8a8a\",\"button_spacing\":\"10\",\"button_spacing_tablet\":\"\",\"button_spacing_mobile\":\"\",\"show_button\":\"true\",\"slide_radius\":\"0\",\"slide_radius_tablet\":\"\",\"slide_radius_mobile\":\"\",\"nav_arrow_spacing\":\"20\",\"nav_arrow_position\":\"100\",\"nav_arrow_radius\":\"0\",\"nav_arrow_size\":\"18\",\"nav_arrow_background_size\":\"42\",\"nav_arrow_background_size_tablet\":\"\",\"nav_arrow_background_size_mobile\":\"\",\"nav_arrow_icon_size\":\"24\",\"nav_arrow_icon_size_tablet\":\"\",\"nav_arrow_icon_size_mobile\":\"\",\"nav_arrow_background\":\"#ffffff\",\"nav_arrow_background_hover\":\"#000000\",\"nav_arrow_icon_color\":\"#000000\",\"nav_arrow_icon_color_hover\":\"#ffffff\",\"dot_color\":\"#000000\",\"dot_color_active\":\"#000000\",\"nav_dots_spacing\":\"20\",\"nav_dots_spacing_tablet\":\"\",\"nav_dots_spacing_mobile\":\"\"},\"items\":[{\"title\":\"Item One\",\"content\":\"Lorem ipsum dolor sit amet, conse ctetur adipisicing elit, sed do eiusmod tempor incididunt ut...\",\"btn_text\":\"Show More\",\"image\":\"[url_assets]\\/placeholder2.jpg\",\"link\":\"#\"},{\"title\":\"Item Two\",\"content\":\"Lorem ipsum dolor sit amet, conse ctetur adipisicing elit, sed do eiusmod tempor incididunt ut...\",\"btn_text\":\"Show More\",\"image\":\"[url_assets]\\/placeholder1.jpg\",\"link\":\"#\"},{\"title\":\"Item Three\",\"content\":\"Lorem ipsum dolor sit amet, conse ctetur adipisicing elit, sed do eiusmod tempor incididunt ut...\",\"btn_text\":\"Show More\",\"image\":\"[url_assets]\\/placeholder4.jpg\",\"link\":\"#\"},{\"title\":\"Item Four\",\"content\":\"Lorem ipsum dolor sit amet, conse ctetur adipisicing elit, sed do eiusmod tempor incididunt ut...\",\"btn_text\":\"Show More\",\"image\":\"[url_assets]\\/placeholder3.jpg\",\"link\":\"#\"}]}',NULL);
